/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.transport.base;

import com.fasterxml.jackson.annotation.JsonBackReference;
import java.math.BigInteger;
import java.util.UUID;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.util.transport.access.AccessTransport;
import org.qubership.automation.itf.core.util.transport.base.Transport;

public abstract class AbstractTransportImpl
implements Transport {
    @JsonBackReference
    private AccessTransport remote;

    @Override
    public AccessTransport getRemote() {
        return this.remote;
    }

    @Override
    public void setRemote(AccessTransport remote) {
        this.remote = remote;
    }

    @Override
    public Message receive(String sessionId) throws Exception {
        throw new UnsupportedOperationException(String.format("Receiving is not supported in asynchronous %s transport", this.getClass().getSimpleName()));
    }

    @Override
    public Message sendReceiveSync(Message messageToSend, BigInteger projectId) throws Exception {
        throw new UnsupportedOperationException(String.format("This method is not supported in %s transport", this.getClass().getSimpleName()));
    }

    @Override
    public String send(Message message, String sessionId, UUID projectUuid) throws Exception {
        throw new UnsupportedOperationException(String.format("Send is not supported in synchronous %s transport", this.getClass().getSimpleName()));
    }
}

