/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.transport.manager;

import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.util.constants.TransportState;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;
import org.qubership.automation.itf.core.util.exception.ExportException;
import org.qubership.automation.itf.core.util.exception.NoDeployedTransportException;
import org.qubership.automation.itf.core.util.exception.TransportException;
import org.qubership.automation.itf.core.util.transport.access.AccessTransport;
import org.qubership.automation.itf.core.util.transport.base.Transport;
import org.qubership.automation.itf.core.util.transport.manager.TransportManager;
import org.qubership.automation.itf.core.util.transport.registry.base.AbstractTransportRegistry;
import org.qubership.automation.itf.core.util.transport.service.Wrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportRegistryManager
implements TransportManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportRegistryManager.class);
    private static TransportRegistryManager INSTANCE = new TransportRegistryManager();
    private AbstractTransportRegistry registry;

    private TransportRegistryManager() {
    }

    public static TransportRegistryManager getInstance() {
        return INSTANCE;
    }

    public void init(AbstractTransportRegistry registry) throws ExportException {
        this.registry = registry;
        this.registry.init();
    }

    @Override
    public void registerTransports(Set<Transport> transports) {
        for (Transport transport : transports) {
            try {
                this.registerTransport(transport);
            }
            catch (ExportException e) {
                LOGGER.error("Error exporting transport {}", (Object)transport.getClass().getName(), (Object)e);
            }
        }
    }

    private void registerTransport(Transport transport) throws ExportException {
        try {
            AccessTransport accessTransport = Wrapper.wrap(transport, this.registry);
            this.registry.register(accessTransport);
        }
        catch (Exception e) {
            throw new ExportException("Error while performing transport export", e);
        }
    }

    @Override
    public void unregister(String typeName) throws TransportException {
        try {
            this.registry.unregister(typeName);
        }
        catch (RemoteException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public void produceEvent(String typeName, MarshalledObject<Message> message, StorableDescriptor triggerConfigurationDescriptor, String sessionId) throws TransportException {
        try {
            this.registry.produceEvent(typeName, message, triggerConfigurationDescriptor, sessionId);
        }
        catch (RemoteException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public AccessTransport find(String typeName) throws NoDeployedTransportException {
        try {
            return this.registry.find(typeName);
        }
        catch (RemoteException e) {
            LOGGER.error("find exception: ", (Throwable)e);
            throw new NoDeployedTransportException(e);
        }
    }

    @Override
    public Map<String, PropertyDescriptor> getProperties(String typeName) throws TransportException {
        try {
            return this.registry.getProperties(typeName);
        }
        catch (RemoteException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public Map<String, AccessTransport> getTransports() throws TransportException {
        try {
            return this.registry.getTransports();
        }
        catch (RemoteException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public Map<String, String> getTransportTypes() throws TransportException {
        try {
            return this.registry.getTransportTypes();
        }
        catch (RemoteException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public Map<String, Pair<String, String>> getViews() throws TransportException {
        try {
            return this.registry.getViews();
        }
        catch (RemoteException e) {
            throw new TransportException(e);
        }
    }

    public void setRegistry(AbstractTransportRegistry registry) {
        this.registry = registry;
    }

    public void destroy() {
        this.registry.destroy();
    }

    public TransportState getState(String typeName) {
        return this.registry.getState(typeName);
    }

    public Map<String, TransportState> getStates() {
        return this.registry.getStates();
    }
}

