/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.transport.registry.base;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.util.constants.TransportState;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;
import org.qubership.automation.itf.core.util.exception.ExportException;
import org.qubership.automation.itf.core.util.exception.TransportException;
import org.qubership.automation.itf.core.util.transport.access.AccessInboundTransport;
import org.qubership.automation.itf.core.util.transport.access.AccessTransport;
import org.qubership.automation.itf.core.util.transport.registry.base.TransportRegistry;
import org.qubership.automation.itf.core.util.transport.service.CoreCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransportRegistry
implements TransportRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTransportRegistry.class);
    private static final boolean deferredActivation = true;
    private static boolean triggersActivationCompleted;
    private Map<String, TransportState> states = Maps.newConcurrentMap();
    private Map<String, String> transportTypes = Maps.newHashMapWithExpectedSize((int)50);
    private Map<String, Boolean> availableServers = Maps.newConcurrentMap();
    private CoreCallback coreCallback;
    private boolean loaded;

    public static boolean isTriggersActivationCompleted() {
        return triggersActivationCompleted;
    }

    public abstract void init() throws ExportException;

    @Override
    public void register(AccessTransport accessTransport) {
        String transportName = "";
        try {
            transportName = accessTransport.getUserName();
            this.states.put(accessTransport.getTypeName(), TransportState.REGISTERING);
            this.protectedRegister(accessTransport);
            this.transportTypes.put(accessTransport.getTypeName(), transportName);
            this.states.put(accessTransport.getTypeName(), TransportState.REGISTERED);
            LOGGER.info("Transport {} registered", (Object)transportName);
        }
        catch (RemoteException | TransportException e) {
            LOGGER.error("Transport didn't registered " + transportName, (Throwable)e);
        }
    }

    protected abstract void protectedRegister(AccessTransport var1) throws TransportException;

    @Override
    public void unregister(String typeName) throws RemoteException {
        this.protectedUnregister(typeName);
        String userName = this.transportTypes.remove(typeName);
        this.states.put(typeName, TransportState.UNDEPLOYED);
        LOGGER.info("Transport {} unregistered", (Object)userName);
    }

    protected abstract void protectedUnregister(String var1) throws RemoteException;

    @Override
    public void produceEvent(String typeName, MarshalledObject<Message> message, StorableDescriptor triggerConfigurationDescriptor, String sessionId) throws RemoteException {
        LOGGER.info("SessionId {}: Transport '{}' / trigger '{}': produced inbound event", new Object[]{sessionId, this.transportTypes.get(typeName), triggerConfigurationDescriptor.getName()});
        try {
            this.coreCallback.produceEvent(message.get(), triggerConfigurationDescriptor, sessionId);
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error("Error unmarshalling object", (Throwable)e);
        }
    }

    @Override
    public void produceEvent(MarshalledObject<Message> message, Object transportId, Object contextId, String sessionId) throws RemoteException {
        try {
            this.coreCallback.produceEvent(message.get(), transportId, contextId, sessionId);
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error("Error unmarshalling object", (Throwable)e);
        }
    }

    @Override
    @Nullable
    public AccessTransport find(String typeName) throws RemoteException {
        return this.protectedFind(typeName);
    }

    protected abstract AccessTransport protectedFind(String var1) throws RemoteException;

    @Override
    public Map<String, PropertyDescriptor> getProperties(String typeName) throws RemoteException {
        AccessTransport transport = this.protectedFind(typeName);
        if (transport == null) {
            return Collections.emptyMap();
        }
        return Maps.uniqueIndex(transport.getProperties(), PropertyDescriptor::getShortName);
    }

    @Override
    public Map<String, AccessTransport> getTransports() throws RemoteException {
        HashMap transports = Maps.newHashMapWithExpectedSize((int)this.transportTypes.size());
        this.transportTypes.keySet().forEach(s -> {
            try {
                transports.put(s, this.protectedFind((String)s));
            }
            catch (RemoteException e) {
                LOGGER.error("NoDeployedTransportException", (Throwable)e);
            }
        });
        return Collections.unmodifiableMap(transports);
    }

    @Override
    public Map<String, String> getTransportTypes() throws RemoteException {
        return Collections.unmodifiableMap(this.transportTypes);
    }

    @Override
    public Map<String, Pair<String, String>> getViews() throws RemoteException {
        HashMap views = Maps.newHashMapWithExpectedSize((int)this.transportTypes.size());
        this.transportTypes.keySet().forEach(typeName -> {
            try {
                AccessTransport accessTransport = this.protectedFind((String)typeName);
                String directive = accessTransport.getDirective();
                String view = accessTransport.getView();
                if (directive == null) {
                    directive = accessTransport instanceof AccessInboundTransport ? "__defaultInboundView__" : "__defaultView__";
                }
                views.put(typeName, Pair.of((Object)directive, (Object)view));
            }
            catch (RemoteException ignored) {
                LOGGER.warn("RemoteException:", (Throwable)ignored);
            }
        });
        return Collections.unmodifiableMap(views);
    }

    public CoreCallback getCoreCallback() {
        return this.coreCallback;
    }

    public void setCoreCallback(CoreCallback coreCallback) {
        this.coreCallback = coreCallback;
    }

    public Map<String, TransportState> getStates() {
        return this.states;
    }

    public TransportState getState(String typeName) {
        TransportState state = this.states.get(typeName);
        if (state == null) {
            state = TransportState.NOT_READY;
        }
        return state;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void setTriggersActivationCompleted(boolean triggersActivationCompleted) {
        AbstractTransportRegistry.triggersActivationCompleted = triggersActivationCompleted;
    }

    public abstract void destroy();
}

