/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.transport.service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.util.config.ApplicationConfig;
import org.qubership.automation.itf.core.util.transport.service.SessionHandler;
import org.qubership.automation.itf.core.util.transport.service.WeakValue;

public enum LockProvider {
    INSTANCE;

    private final int timeout = this.setTimeout(Integer.parseInt(ApplicationConfig.env.getProperty("lock.provider.process.timeout", "25000")), 25000);
    private LoadingCache<String, WeakValue> locks = CacheBuilder.newBuilder().expireAfterWrite((long)this.timeout, TimeUnit.MILLISECONDS).removalListener(notification -> {
        WeakValue weakValue = (WeakValue)notification.getValue();
        synchronized (weakValue) {
            ((WeakValue)notification.getValue()).notify();
        }
    }).build((CacheLoader)new CacheLoader<String, WeakValue>(){

        public WeakValue load(@Nonnull String id) {
            return new WeakValue();
        }
    });

    public void notify(@Nonnull String key) {
        WeakValue value = (WeakValue)this.locks.getIfPresent((Object)key);
        if (value != null) {
            this.locks.invalidate((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait(@Nonnull String sessionId) throws InterruptedException {
        WeakValue lock;
        WeakValue weakValue = lock = (WeakValue)this.locks.getUnchecked((Object)sessionId);
        synchronized (weakValue) {
            lock.wait(this.timeout);
        }
    }

    public Message waitResponse(@Nonnull String sessionId, int interval) throws InterruptedException {
        return this.waitResponse(sessionId, interval, interval, 1.0f);
    }

    public Message waitResponse(@Nonnull String sessionId, int interval, int maxInterval, float multiplier) throws InterruptedException {
        int checkedInterval = interval < 50 || interval >= this.timeout ? 500 : interval;
        float checkedMultiplier = Math.max(multiplier, 1.0f);
        int checkedMaxInterval = checkedMultiplier == 1.0f ? checkedInterval : maxInterval;
        return this.waitAndGetResponse(sessionId, checkedInterval, checkedMaxInterval, checkedMultiplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message waitAndGetResponse(@Nonnull String sessionId, int interval, int maxInterval, float multiplier) throws InterruptedException {
        Message response = SessionHandler.INSTANCE.getMessage(sessionId);
        if (response == null) {
            WeakValue lock;
            int elapsed = 0;
            int newInterval = interval;
            WeakValue weakValue = lock = (WeakValue)this.locks.getUnchecked((Object)sessionId);
            synchronized (weakValue) {
                while (response == null) {
                    lock.wait(newInterval);
                    response = SessionHandler.INSTANCE.getMessage(sessionId);
                    if ((elapsed += newInterval) >= this.timeout) break;
                    newInterval = this.computeInterval(newInterval, maxInterval, multiplier);
                }
            }
        }
        return response;
    }

    public boolean init() {
        return true;
    }

    public void cleanupCache() {
        this.locks.cleanUp();
    }

    private int setTimeout(int timeout, int defaultValue) {
        return timeout > 0 ? timeout : defaultValue;
    }

    private int computeInterval(int oldInterval, int maxInterval, float multiplier) {
        if (multiplier == 1.0f) {
            return oldInterval;
        }
        int newInterval = Math.round((float)oldInterval * multiplier);
        return Math.min(newInterval, maxInterval);
    }
}

