/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.transport.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.transport.service.LockProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SessionHandler {
    INSTANCE;

    private static final Logger LOGGER;
    public final int timeout = this.setTimeout(Config.getConfig().getInt("session.handler.process.timeout"), 20000);
    private Cache<String, Message> cache = CacheBuilder.newBuilder().expireAfterWrite((long)this.timeout, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<String, Message>(){

        public void onRemoval(@Nonnull RemovalNotification<String, Message> notification) {
            if (notification.wasEvicted() && notification.getCause().equals((Object)RemovalCause.EXPIRED)) {
                LockProvider.INSTANCE.notify((String)notification.getKey());
                LOGGER.warn("Response message was expired (timeout is {} sec.) and removed from cache for sessionId {}.", (Object)TimeUnit.MILLISECONDS.toSeconds(SessionHandler.this.timeout), notification.getKey());
            }
        }
    }).build();

    @Nullable
    public Message getMessage(@Nonnull String session) {
        Message message = (Message)this.cache.getIfPresent((Object)session);
        if (message != null) {
            this.cache.invalidate((Object)session);
        }
        return message;
    }

    public void addMessage(@Nonnull String sessionId, @Nonnull Message message) {
        this.cache.put((Object)sessionId, (Object)message);
    }

    public void remove(@Nonnull String sessionId) {
        if (this.cache.getIfPresent((Object)sessionId) != null) {
            this.cache.invalidate((Object)sessionId);
        }
    }

    public boolean init() {
        return true;
    }

    public void cleanupCache() {
        this.cache.cleanUp();
    }

    private int setTimeout(int timeout, int defaultValue) {
        return timeout > 0 ? timeout : defaultValue;
    }

    static {
        LOGGER = LoggerFactory.getLogger(SessionHandler.class);
    }
}

