/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.transport.service.report;

import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.SpContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.transport.service.report.ReportAdapter;
import org.qubership.automation.itf.core.util.transport.service.report.ReportAdapterStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Report {
    public static final Logger LOGGER = LoggerFactory.getLogger(Report.class);

    public static void openSection(AbstractInstance instance, String title) {
        for (ReportAdapter reportAdapter : ReportAdapterStorage.getInstance().getAdapters()) {
            if (!reportAdapter.needToReport(instance.getContext().tc())) continue;
            try {
                reportAdapter.openSection(instance, title);
            }
            catch (Throwable ex) {
                LOGGER.error("Report Adapter {} Error while 'openSection'", (Object)reportAdapter, (Object)ex);
            }
        }
    }

    public static void closeSection(AbstractInstance instance) {
        for (ReportAdapter reportAdapter : ReportAdapterStorage.getInstance().getAdapters()) {
            if (!reportAdapter.needToReport(instance.getContext().tc())) continue;
            try {
                reportAdapter.closeSection(instance);
            }
            catch (Throwable ex) {
                LOGGER.error("Report Adapter {} Error while 'closeSection'", (Object)reportAdapter, (Object)ex);
            }
        }
    }

    public static void info(AbstractInstance instance, String title, SpContext spContext) {
        for (ReportAdapter reportAdapter : ReportAdapterStorage.getInstance().getAdapters()) {
            if (!reportAdapter.needToReport(instance.getContext().tc())) continue;
            try {
                reportAdapter.info(instance, title, spContext);
            }
            catch (Throwable ex) {
                LOGGER.error("Report Adapter {} Error while 'info'", (Object)reportAdapter, (Object)ex);
            }
        }
    }

    public static void info(AbstractInstance instance, String title, String message) {
        for (ReportAdapter reportAdapter : ReportAdapterStorage.getInstance().getAdapters()) {
            if (!reportAdapter.needToReport(instance.getContext().tc())) continue;
            try {
                reportAdapter.info(instance, title, message);
            }
            catch (Throwable ex) {
                LOGGER.error("Report Adapter {} Error while 'info'", (Object)reportAdapter, (Object)ex);
            }
        }
    }

    public static void warn(AbstractInstance instance, String title, String message) {
        for (ReportAdapter reportAdapter : ReportAdapterStorage.getInstance().getAdapters()) {
            if (!reportAdapter.needToReport(instance.getContext().tc())) continue;
            try {
                reportAdapter.warn(instance, title, message);
            }
            catch (Throwable ex) {
                LOGGER.error("Report Adapter {} Error while 'warn'", (Object)reportAdapter, (Object)ex);
            }
        }
    }

    public static void error(AbstractInstance instance, String title, SpContext spContext, Throwable exception) {
        for (ReportAdapter reportAdapter : ReportAdapterStorage.getInstance().getAdapters()) {
            if (!reportAdapter.needToReport(instance.getContext().tc())) continue;
            try {
                reportAdapter.error(instance, title, spContext, exception);
            }
            catch (Throwable ex) {
                LOGGER.error("Report Adapter {} Error while 'error'", (Object)reportAdapter, (Object)ex);
            }
        }
    }

    public static void error(AbstractInstance instance, String title, String message, Throwable exception) {
        for (ReportAdapter reportAdapter : ReportAdapterStorage.getInstance().getAdapters()) {
            if (!reportAdapter.needToReport(instance.getContext().tc())) continue;
            try {
                reportAdapter.error(instance, title, message, exception);
            }
            catch (Throwable ex) {
                LOGGER.error("Report Adapter {} Error while 'error'", (Object)reportAdapter, (Object)ex);
            }
        }
    }

    public static void terminated(AbstractInstance instance, String title, String message, Throwable exception) {
        for (ReportAdapter reportAdapter : ReportAdapterStorage.getInstance().getAdapters()) {
            if (!reportAdapter.needToReport(instance.getContext().tc())) continue;
            try {
                reportAdapter.terminated(instance, title, message, exception);
            }
            catch (Throwable ex) {
                LOGGER.error("Report Adapter {} Error while 'terminated'", (Object)reportAdapter, (Object)ex);
            }
        }
    }

    public static void startRun(TcContext context) {
        for (ReportAdapter reportAdapter : ReportAdapterStorage.getInstance().getAdapters()) {
            if (!reportAdapter.needToReport(context)) continue;
            try {
                reportAdapter.startRun(context);
            }
            catch (Throwable ex) {
                LOGGER.error("Report Adapter {} Error while 'startRun'", (Object)reportAdapter, (Object)ex);
            }
        }
    }

    public static void startAtpRun(String testRunId) {
        for (ReportAdapter reportAdapter : ReportAdapterStorage.getInstance().getAdapters()) {
            try {
                reportAdapter.startAtpRun(testRunId);
            }
            catch (Throwable ex) {
                LOGGER.error("Report Adapter {} Error while 'startAtpRun'", (Object)reportAdapter, (Object)ex);
            }
        }
    }

    public static void stopRun(InstanceContext context, Status status) {
        for (ReportAdapter reportAdapter : ReportAdapterStorage.getInstance().getAdapters()) {
            if (!reportAdapter.needToReport(context.tc())) continue;
            try {
                reportAdapter.stopRun(context, status);
            }
            catch (Throwable ex) {
                LOGGER.error("Report Adapter {} Error while 'stopRun'", (Object)reportAdapter, (Object)ex);
            }
        }
    }

    public static void stopAllRuns() {
        for (ReportAdapter reportAdapter : ReportAdapterStorage.getInstance().getAdapters()) {
            try {
                reportAdapter.stopAllRuns();
            }
            catch (Throwable ex) {
                LOGGER.error("Report Adapter {} Error while 'stopAllRuns'", (Object)reportAdapter, (Object)ex);
            }
        }
    }

    public static void reportCallChainInfo(CallChainInstance instance) {
        for (ReportAdapter reportAdapter : ReportAdapterStorage.getInstance().getAdapters()) {
            if (!reportAdapter.needToReport(instance.getContext().tc())) continue;
            try {
                reportAdapter.reportCallChainInfo(instance);
            }
            catch (Throwable ex) {
                LOGGER.error("Report Adapter {} Error while 'reportCallChainInfo'", (Object)reportAdapter, (Object)ex);
            }
        }
    }
}

