package org.qubership.atp.bv.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.bv.dto.GlobalRuleDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * SimplifiedValidationObjectDto
 */

@JsonTypeName("SimplifiedValidationObject")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-17T03:06:35.022Z[Etc/UTC]")
public class SimplifiedValidationObjectDto {

  @JsonProperty("ar")
  private String ar;

  @JsonProperty("children")
  @Valid
  private List<SimplifiedValidationObjectDto> children = null;

  @JsonProperty("name")
  private String name;

  /**
   * Gets or Sets parameterType
   */
  public enum ParameterTypeEnum {
    CONTEXT_PARAMETER("CONTEXT_PARAMETER"),
    
    FULL_TEXT("FULL_TEXT"),
    
    INTEGRATION_CALL("INTEGRATION_CALL"),
    
    JSON("JSON"),
    
    PLAIN_TEXT("PLAIN_TEXT"),
    
    PRIMITIVES("PRIMITIVES"),
    
    TABLE("TABLE"),
    
    TASK_LIST("TASK_LIST"),
    
    XML("XML"),
    
    XSD("XSD");

    private String value;

    ParameterTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ParameterTypeEnum fromValue(String value) {
      for (ParameterTypeEnum b : ParameterTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("parameterType")
  private ParameterTypeEnum parameterType;

  @JsonProperty("rules")
  @Valid
  private List<GlobalRuleDto> rules = null;

  @JsonProperty("value")
  private String value;

  public SimplifiedValidationObjectDto ar(String ar) {
    this.ar = ar;
    return this;
  }

  /**
   * Get ar
   * @return ar
  */
  
  @Schema(name = "ar", required = false)
  public String getAr() {
    return ar;
  }

  public void setAr(String ar) {
    this.ar = ar;
  }

  public SimplifiedValidationObjectDto children(List<SimplifiedValidationObjectDto> children) {
    this.children = children;
    return this;
  }

  public SimplifiedValidationObjectDto addChildrenItem(SimplifiedValidationObjectDto childrenItem) {
    if (this.children == null) {
      this.children = new ArrayList<>();
    }
    this.children.add(childrenItem);
    return this;
  }

  /**
   * Get children
   * @return children
  */
  @Valid 
  @Schema(name = "children", required = false)
  public List<SimplifiedValidationObjectDto> getChildren() {
    return children;
  }

  public void setChildren(List<SimplifiedValidationObjectDto> children) {
    this.children = children;
  }

  public SimplifiedValidationObjectDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public SimplifiedValidationObjectDto parameterType(ParameterTypeEnum parameterType) {
    this.parameterType = parameterType;
    return this;
  }

  /**
   * Get parameterType
   * @return parameterType
  */
  
  @Schema(name = "parameterType", required = false)
  public ParameterTypeEnum getParameterType() {
    return parameterType;
  }

  public void setParameterType(ParameterTypeEnum parameterType) {
    this.parameterType = parameterType;
  }

  public SimplifiedValidationObjectDto rules(List<GlobalRuleDto> rules) {
    this.rules = rules;
    return this;
  }

  public SimplifiedValidationObjectDto addRulesItem(GlobalRuleDto rulesItem) {
    if (this.rules == null) {
      this.rules = new ArrayList<>();
    }
    this.rules.add(rulesItem);
    return this;
  }

  /**
   * Get rules
   * @return rules
  */
  @Valid 
  @Schema(name = "rules", required = false)
  public List<GlobalRuleDto> getRules() {
    return rules;
  }

  public void setRules(List<GlobalRuleDto> rules) {
    this.rules = rules;
  }

  public SimplifiedValidationObjectDto value(String value) {
    this.value = value;
    return this;
  }

  /**
   * Get value
   * @return value
  */
  
  @Schema(name = "value", required = false)
  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SimplifiedValidationObjectDto simplifiedValidationObject = (SimplifiedValidationObjectDto) o;
    return Objects.equals(this.ar, simplifiedValidationObject.ar) &&
        Objects.equals(this.children, simplifiedValidationObject.children) &&
        Objects.equals(this.name, simplifiedValidationObject.name) &&
        Objects.equals(this.parameterType, simplifiedValidationObject.parameterType) &&
        Objects.equals(this.rules, simplifiedValidationObject.rules) &&
        Objects.equals(this.value, simplifiedValidationObject.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ar, children, name, parameterType, rules, value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SimplifiedValidationObjectDto {\n");
    sb.append("    ar: ").append(toIndentedString(ar)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    parameterType: ").append(toIndentedString(parameterType)).append("\n");
    sb.append("    rules: ").append(toIndentedString(rules)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

