/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.bv.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.bv.dto.CopyWithNameRequestDto;
import org.qubership.atp.bv.dto.GetTestcaseRequestDto;
import org.qubership.atp.bv.dto.TestCaseForExportDto;
import org.qubership.atp.bv.dto.TestCaseParameterDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
@Tag(name="TestCaseResource", description="Test Case Resource")
public interface TestCaseResourceApi {
    @Operation(operationId="attachValidationObject", summary="attachValidationObject", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/attachValidationObject"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> attachValidationObject(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="attachValidationObjectToTop", summary="attachValidationObjectToTop", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/attachValidationObjectToTop"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> attachValidationObjectToTop(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="attachValidationObjectWithoutER", summary="attachValidationObjectWithoutER", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/attachValidationObjectWithoutER"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> attachValidationObjectWithoutER(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="browseTestCases", summary="browseTestCases", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/browseTestCases"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> browseTestCases(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="bulkUpdate", summary="bulkUpdate", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/bulkUpdate"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> bulkUpdate(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="checkExistingTestCaseName", summary="checkExistingTestCaseName", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/checkExistingTestCaseName"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> checkExistingTestCaseName(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="checkName", summary="checkName", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/checkName"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> checkName(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="clearEr", summary="clearEr", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/clearEr"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> clearEr(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="cloneVObjectValue", summary="cloneVObjectValue", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/cloneVObjectValue"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> cloneVObjectValue(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="copyTestRun", summary="copyTestRun", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/copyTestRun"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> copyTestRun(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="copyValObjects", summary="copyValObjects", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/copyValObjs"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> copyValObjects(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="copyWithName", summary="copyWithName", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/copyWithName"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> copyWithName(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="CopyWithNameRequestDto", description="") @Valid @RequestBody(required=false) CopyWithNameRequestDto var2);

    @Operation(operationId="create", summary="create", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/create"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> create(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="createInputParameter", summary="createInputParameter", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/createInputParameter"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> createInputParameter(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="detachAllValidationObject", summary="detachAllValidationObject", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/detachAllValidationObject"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> detachAllValidationObject(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="detachValidationObject", summary="detachValidationObject", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/detachValidationObject"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> detachValidationObject(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="export", summary="export", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/export"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> export(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="getParameterValue", summary="getParameterValue", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/getParameterValue"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> getParameterValue(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="getParameters", summary="getParameters", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/getParameters"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> getParameters(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="getSimpleTestCasesByIds", summary="getSimpleTestCasesByIds", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/getSimpleTestCasesByIds"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> getSimpleTestCasesByIds(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="request_body", description="") @Valid @RequestBody(required=false) List<String> var2);

    @Operation(operationId="getTestCase", summary="getTestCase", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/getTestCase"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> getTestCase(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="GetTestcaseRequestDto", description="") @Valid @RequestBody(required=false) GetTestcaseRequestDto var2);

    @Operation(operationId="getTestCaseRuns", summary="getTestCaseRuns", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/getTestCaseRuns"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> getTestCaseRuns(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="getTestCaseStatus", summary="getTestCaseStatus", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/getTestCaseStatus"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> getTestCaseStatus(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="getTestCasesByIds", summary="getTestCasesByIds", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/getTestCasesByIds"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> getTestCasesByIds(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="getTestCasesByScopes", summary="getTestCasesByScopes", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/bvtool/project/{projectId}/testcases/v1/getTestCasesByScopes"}, produces={"application/json"})
    public ResponseEntity<String> getTestCasesByScopes(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getTestCasesForExport", summary="getTestCasesForExport", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseForExportDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/getTestCasesForExport"}, produces={"application/json"})
    public ResponseEntity<List<TestCaseForExportDto>> getTestCasesForExport(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getTestCasesRunsByFilter", summary="getTestCasesRunsByFilter", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/getTestCasesRunsByFilter"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> getTestCasesRunsByFilter(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="getTestCasesScopes", summary="getTestCasesScopes", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/bvtool/project/{projectId}/testcases/v1/getTestCasesScopes"}, produces={"application/json"})
    public ResponseEntity<String> getTestCasesScopes(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getTestCasesUsingPUT", summary="getTestCases", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/getTestCases"}, produces={"application/json"})
    public ResponseEntity<String> getTestCasesUsingPUT(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getTestRun", summary="getTestRun", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/getTestCaseRun"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> getTestRun(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="getTestRuns", summary="getTestRuns", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/getTestRuns"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> getTestRuns(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="moveParameterItem", summary="moveParameterItem", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/moveParameterItem"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> moveParameterItem(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="remove", summary="remove", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/remove"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> remove(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="removeInputParameter", summary="removeInputParameter", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/removeInputParameter"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> removeInputParameter(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="removeOldTestRuns", summary="removeOldTestRuns", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/removeOldTestRuns"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> removeOldTestRuns(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="removeTestRun", summary="removeTestRun", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/removeTestRuns"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> removeTestRun(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="setValidationObjectsImportance", summary="setValidationObjectsImportance", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/{testCaseId}/toggleValidationObjectImportance"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Object> setValidationObjectsImportance(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="testCaseId", description="testCaseId", required=true) @PathVariable(value="testCaseId") String var2, @Parameter(name="request_body", description="") @Valid @RequestBody(required=false) List<String> var3);

    @Operation(operationId="update", summary="update", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/update"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> update(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="updateContent", summary="updateContent", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/updateContent"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> updateContent(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="updateEthalonValue", summary="updateEthalonValue", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/updateVObject"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> updateEthalonValue(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="updateInputParameter", summary="updateInputParameter", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/updateInputParameter"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> updateInputParameter(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="TestCaseParameterDto", description="") @Valid @RequestBody(required=false) TestCaseParameterDto var2);

    @Operation(operationId="updateStatusCommentInTestRun", summary="updateStatusCommentInTestRun", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/updateStatusCommentInTestRun"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> updateStatusCommentInTestRun(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="updateStatusInTestRun", summary="updateStatusInTestRun", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/updateStatusInTestRun"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> updateStatusInTestRun(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="updateTestCaseParameter", summary="updateTestCaseParameter", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/updateLockedStatus"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> updateTestCaseParameter(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="updateTestRunParameterValue", summary="updateTestRunParameterValue", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/updateTestRunParameterValue"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> updateTestRunParameterValue(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="updateVObjectValue", summary="updateVObjectValue", tags={"test-case-resource"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/bvtool/project/{projectId}/testcases/v1/updateVObjectValue"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> updateVObjectValue(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);
}

