/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.datasets.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.datasets.dto.AttributeCreateResponseDto;
import org.qubership.atp.datasets.dto.AttributeDto;
import org.qubership.atp.datasets.dto.AttributeTypeDto;
import org.qubership.atp.datasets.dto.ListValueDto;
import org.qubership.atp.datasets.dto.PairOfUUidAndIntDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="AttributeController", description="Attribute Controller")
public interface AttributeControllerApi {
    @Operation(operationId="bulkDeleteListValues", summary="Bulk delete list values by id.", tags={"attribute-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/attribute/{attributeId}/bulk"})
    public ResponseEntity<Void> bulkDeleteListValues(@Parameter(name="attributeId", description="attributeId", required=true) @PathVariable(value="attributeId") UUID var1, @NotNull @Parameter(name="listValues", description="listValues", required=true) @Valid @RequestParam(value="listValues", required=true) UUID var2, @Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var3, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var4);

    @Operation(operationId="create", summary="Creates new attribute with provided name and order.", tags={"attribute-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=AttributeCreateResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/attribute/dsl/{dataSetListId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<AttributeCreateResponseDto> create(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1, @NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var2, @NotNull @Parameter(name="ordering", description="ordering", required=true) @Valid @RequestParam(value="ordering", required=true) Integer var3, @NotNull @Parameter(name="type", description="type", required=true) @Valid @RequestParam(value="type", required=true) AttributeTypeDto var4, @Parameter(name="typeDataSetListId", description="typeDataSetListId") @Valid @RequestParam(value="typeDataSetListId", required=false) UUID var5, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var6, @Parameter(name="request_body", description="") @Valid @RequestBody(required=false) List<String> var7);

    @Operation(operationId="createListValue", summary="Creates new list value for provided attribute.", tags={"attribute-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListValueDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/attribute/{attributeId}/listValues"}, produces={"application/json"})
    public ResponseEntity<ListValueDto> createListValue(@Parameter(name="attributeId", description="attributeId", required=true) @PathVariable(value="attributeId") UUID var1, @NotNull @Parameter(name="value", description="value", required=true) @Valid @RequestParam(value="value", required=true) String var2, @Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var3, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var4);

    @Operation(operationId="createListValues", summary="Creates new list values for provided attribute by text.", tags={"attribute-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/attribute/{attributeId}/listValues"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<UUID>> createListValues(@Parameter(name="attributeId", description="attributeId", required=true) @PathVariable(value="attributeId") UUID var1, @Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var2, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var3, @Parameter(name="request_body", description="") @Valid @RequestBody(required=false) List<String> var4);

    @Operation(operationId="delete", summary="Deletes selected attribute.", tags={"attribute-controller"}, responses={@ApiResponse(responseCode="204", description="No Content", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/attribute/{attributeId}"}, produces={"application/json"})
    public ResponseEntity<Boolean> delete(@Parameter(name="attributeId", description="attributeId", required=true) @PathVariable(value="attributeId") UUID var1, @Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var2, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var3);

    @Operation(operationId="deleteAllByDsl", summary="Deletes attributes from the selected dataSetsList.", tags={"attribute-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/attribute/dsl/{dataSetListId}/all"})
    public ResponseEntity<Void> deleteAllByDsl(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var2);

    @Operation(operationId="deleteListValue", summary="Delete list value by id.", tags={"attribute-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/attribute/{attributeId}/listValues/{listValueId}"})
    public ResponseEntity<Void> deleteListValue(@Parameter(name="attributeId", description="attributeId", required=true) @PathVariable(value="attributeId") UUID var1, @Parameter(name="listValueId", description="listValueId", required=true) @PathVariable(value="listValueId") UUID var2, @Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var3, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var4);

    @Operation(operationId="get", summary="Returns attribute.", tags={"attribute-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=AttributeDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/attribute/{attributeId}"}, produces={"application/json"})
    public ResponseEntity<AttributeDto> get(@Parameter(name="attributeId", description="attributeId", required=true) @PathVariable(value="attributeId") UUID var1);

    @Operation(operationId="getAttributes", summary="Returns all attributes by dataSetList id.", tags={"attribute-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=AttributeDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/attribute/dsl/{dataSetListId}"}, produces={"application/json"})
    public ResponseEntity<List<AttributeDto>> getAttributes(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1);

    @Operation(operationId="getAttributesInItfFormat", summary="Returns all attributes by dataSetList id in itf format: [attr1.attr2, attr1].", tags={"attribute-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/attribute/dsl/{dataSetListId}/itf"}, produces={"application/json"})
    public ResponseEntity<Object> getAttributesInItfFormat(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1);

    @Operation(operationId="getOptions", summary="getOptions", tags={"attribute-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/attribute/{attributeId}/options"}, produces={"application/json"})
    public ResponseEntity<Object> getOptions(@Parameter(name="attributeId", description="attributeId", required=true) @PathVariable(value="attributeId") UUID var1);

    @Operation(operationId="getParametersValuesAndDataSetIdsForAttributeValuesSorting", summary="Sort Attribute values.", tags={"attribute-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=List.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/attribute/{dataSetListId}/existedValues"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<List>> getParametersValuesAndDataSetIdsForAttributeValuesSorting(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1, @NotNull @Parameter(name="targetAttrId", description="targetAttrId", required=true) @Valid @RequestParam(value="targetAttrId", required=true) UUID var2, @Parameter(name="request_body", description="") @Valid @RequestBody(required=false) Map<String, Set<UUID>> var3);

    @Operation(operationId="rename", summary="Renames selected attribute.", tags={"attribute-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/attribute/{attributeId}"}, produces={"application/json"})
    public ResponseEntity<Boolean> rename(@Parameter(name="attributeId", description="attributeId", required=true) @PathVariable(value="attributeId") UUID var1, @NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var2, @Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var3, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var4);

    @Operation(operationId="setPosition", summary="Creates new list values for provided attribute by text.", tags={"attribute-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/attribute/{attributeId}/position"}, consumes={"application/json"})
    public ResponseEntity<Void> setPosition(@Parameter(name="attributeId", description="attributeId", required=true) @PathVariable(value="attributeId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) Integer var2);

    @Operation(operationId="updateDslReference", summary="Update DSL reference.", tags={"attribute-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/attribute/{attributeId}/dataSetListReference"}, produces={"application/json"})
    public ResponseEntity<Boolean> updateDslReference(@Parameter(name="attributeId", description="attributeId", required=true) @PathVariable(value="attributeId") UUID var1, @Parameter(name="value", description="value") @Valid @RequestParam(value="value", required=false) UUID var2);

    @Operation(operationId="updateOrdering", summary="updateOrdering", tags={"attribute-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/attribute/updateOrdering"}, consumes={"application/json"})
    public ResponseEntity<Void> updateOrdering(@Parameter(name="PairOfUUidAndIntDto", description="") @Valid @RequestBody(required=false) List<PairOfUUidAndIntDto> var1);
}

