/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.datasets.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.UUID;
import org.qubership.atp.datasets.dto.DataSetListFlatDto;
import org.qubership.atp.datasets.dto.RefDataSetListFlatDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
@Tag(name="DataSetListLazyLoadingController", description="Data Set List Lazy Loading Controller")
public interface DataSetListLazyLoadingControllerApi {
    @Operation(operationId="getDataSetListFlat", summary="Returns information about the selected DSL.", tags={"data-set-list-lazy-loading-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataSetListFlatDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl/lazy/{dataSetListId}"}, produces={"application/json"})
    public ResponseEntity<DataSetListFlatDto> getDataSetListFlat(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1);

    @Operation(operationId="getReferencedDataSetList", summary="Returns information about the selected DSL.", tags={"data-set-list-lazy-loading-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=RefDataSetListFlatDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl/lazy/{dataSetListId}/ReferenceByPath/{attributePath}"}, produces={"application/json"})
    public ResponseEntity<RefDataSetListFlatDto> getReferencedDataSetList(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1, @Parameter(name="attributePath", description="attributePath", required=true) @PathVariable(value="attributePath") String var2);
}

