/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.config;

import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.qubership.automation.itf.core.config.BeanAwareSpringLiquibase;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;

@Configuration
@EnableConfigurationProperties(value={LiquibaseProperties.class})
public class SpringLiquibaseConfiguration {
    private final ResourceLoader resourceLoader;

    @Bean
    @ConditionalOnMissingBean
    public LiquibaseProperties liquibaseProperties() {
        return new LiquibaseProperties();
    }

    @Bean(name={"springLiquibase"})
    @ConditionalOnProperty(name={"atp.multi-tenancy.enabled"}, havingValue="false", matchIfMissing=true)
    public SpringLiquibase springLiquibaseWithDisabledMultiTenancy(DataSource dataSource, LiquibaseProperties liquibaseProperties) {
        BeanAwareSpringLiquibase springLiquibase = new BeanAwareSpringLiquibase();
        springLiquibase.setResourceLoader(this.resourceLoader);
        springLiquibase.setChangeLog(liquibaseProperties.getChangeLog());
        springLiquibase.setContexts(liquibaseProperties.getContexts());
        springLiquibase.setDefaultSchema(liquibaseProperties.getDefaultSchema());
        springLiquibase.setDropFirst(liquibaseProperties.isDropFirst());
        springLiquibase.setShouldRun(liquibaseProperties.isEnabled());
        springLiquibase.setLabels(liquibaseProperties.getLabels());
        springLiquibase.setChangeLogParameters(liquibaseProperties.getParameters());
        springLiquibase.setRollbackFile(liquibaseProperties.getRollbackFile());
        springLiquibase.setDataSource(dataSource);
        return springLiquibase;
    }

    @Bean(name={"springLiquibase"})
    @ConditionalOnProperty(name={"atp.multi-tenancy.enabled"}, havingValue="true")
    public SpringLiquibase springLiquibaseWithEnabledMultiTenancy(LiquibaseProperties liquibaseProperties) {
        BeanAwareSpringLiquibase springLiquibase = new BeanAwareSpringLiquibase();
        springLiquibase.setResourceLoader(this.resourceLoader);
        springLiquibase.setChangeLogParameters(liquibaseProperties.getParameters());
        springLiquibase.setShouldRun(false);
        return springLiquibase;
    }

    public SpringLiquibaseConfiguration(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

