/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.AttributeConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapConverter
implements AttributeConverter<Map<String, String>, String> {
    private static final Logger log = LoggerFactory.getLogger(MapConverter.class);
    ObjectMapper objectMapper = new ObjectMapper();

    public String convertToDatabaseColumn(Map<String, String> attribute) {
        String attributeJson = null;
        try {
            attributeJson = this.objectMapper.writeValueAsString(attribute);
        }
        catch (JsonProcessingException e) {
            log.error("JSON writing error", (Throwable)e);
        }
        return attributeJson;
    }

    public Map<String, String> convertToEntityAttribute(String dbData) {
        Map<String, String> map = new HashMap<String, String>();
        try {
            if (StringUtils.isNotBlank((CharSequence)dbData)) {
                map = (Map)this.objectMapper.readValue(dbData, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            }
        }
        catch (IOException e) {
            log.error("JSON reading error", (Throwable)e);
        }
        return map;
    }
}

