/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.executor;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.EventTriggerRepository;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.system.stub.EventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.OperationEventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;

public abstract class EventTriggerObjectManager<T extends EventTrigger>
extends AbstractObjectManager<T, T> {
    private Map<String, Class<? extends EventTrigger>> subclasses;

    public EventTriggerObjectManager(Class<T> clazz, EventTriggerRepository<T> repository) {
        super(clazz, repository);
    }

    @Override
    public void protectedOnRemove(T eventTrigger) {
    }

    @Override
    public T create(Storable parent, String type) {
        Class<? extends EventTrigger> triggerClass = this.subclasses.get(type);
        if (triggerClass == null) {
            throw new IllegalArgumentException("Cannot create trigger of type " + type);
        }
        try {
            EventTrigger result = triggerClass.newInstance();
            result.setParent(parent);
            result = (EventTrigger)this.repository.save(result);
            return (T)result;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Cannot create trigger of type " + type + " with class " + triggerClass.getCanonicalName(), e);
        }
    }

    @Override
    public T create() {
        throw new IllegalArgumentException("Cannot create trigger of unknown type!");
    }

    @PostConstruct
    protected void init() {
        this.subclasses = new HashMap<String, Class<? extends EventTrigger>>(){
            {
                this.put("Operation Event Trigger", OperationEventTrigger.class);
                this.put("Situation Event Trigger", SituationEventTrigger.class);
            }
        };
    }
}

