/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.executor;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.ByProject;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.OperationRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.StepRepository;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.model.usage.UsageInfo;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.copier.OriginalCopyMap;
import org.qubership.automation.itf.core.util.copier.StorableCopier;
import org.qubership.automation.itf.core.util.exception.CopyException;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperationObjectManager
extends AbstractObjectManager<Operation, Operation>
implements ByProject<Operation> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationObjectManager.class);
    private final StepRepository stepRepository;

    @Autowired
    public OperationObjectManager(OperationRepository repository, StepRepository stepRepository) {
        super(Operation.class, repository);
        this.stepRepository = stepRepository;
    }

    @Override
    public void protectedOnRemove(Operation object) {
        this.stepRepository.onDeleteOperation(object);
    }

    @Override
    public Collection<UsageInfo> findUsages(Storable storable) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)500);
        ArrayList all = storable instanceof Operation ? this.stepRepository.getIntegrationStepsByOperation((Operation)storable) : new ArrayList();
        OperationObjectManager.addToUsages(result, "operation", all);
        return result;
    }

    @Override
    public Map<String, List<BigInteger>> findImportantChildren(Storable storable) {
        if (storable instanceof Operation) {
            List<BigInteger> seTriggerIds = ((OperationRepository)this.repository).getSituationEventTriggersByOperationId(IdConverter.toBigInt(storable.getID()));
            HashMap<String, List<BigInteger>> result = new HashMap<String, List<BigInteger>>();
            result.put("SituationEventTriggers", seTriggerIds);
            return result;
        }
        return super.findImportantChildren(storable);
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only Operation objects are here")
    public void additionalMoveActions(Storable operation, String sessionId) {
        Storable cachedTransportCopy;
        TransportConfiguration transport = ((Operation)operation).getTransport();
        if (transport != null && (cachedTransportCopy = OriginalCopyMap.getInstance().get(sessionId, transport.getID())) == null) {
            try {
                cachedTransportCopy = new StorableCopier(sessionId).copy(transport, operation.getParent(), ((Folder)operation.getParent().getParent()).getProject().getID().toString(), "copy");
                OriginalCopyMap.getInstance().put(sessionId, transport.getID(), cachedTransportCopy);
                cachedTransportCopy.store();
                ((Operation)operation).setTransport((TransportConfiguration)cachedTransportCopy);
            }
            catch (CopyException e) {
                LOGGER.error("Can't create the copy of {} transport for moved {} operation. Please, fill the transport manualy.", (Object)transport.getName(), (Object)operation.getName());
            }
        }
        for (Situation situation : ((Operation)operation).getSituations()) {
            CoreObjectManager.getInstance().getManager(Situation.class).additionalMoveActions(situation, sessionId);
        }
        operation.store();
    }

    @Override
    public Collection<Operation> getAllByProject(Object projectId) {
        throw new NotImplementedException("Not implemented for project");
    }

    @Override
    public Collection<Operation> getByPieceOfNameAndProject(String name, Object projectId) {
        return ((OperationRepository)this.repository).findByPieceOfNameAndProject(name, IdConverter.toBigInt(projectId));
    }

    @Override
    public List<Operation> getByNameAndProjectId(String name, BigInteger projectId) {
        return ((OperationRepository)this.repository).findByNameAndProjectId(name, IdConverter.toBigInt(projectId));
    }

    @Override
    public Collection<Operation> getByParentNameAndProject(String name, Object projectId) {
        return ((OperationRepository)this.repository).findByParentNameAndProject(name, IdConverter.toBigInt(projectId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only Operation objects are here")
    public void afterDelete(Storable object) {
        if (object.getParent() instanceof System) {
            Storable storable = object.getParent();
            synchronized (storable) {
                ((System)object.getParent()).getOperations().remove((Operation)object);
            }
        }
    }
}

