/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.executor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.StepRepository;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.container.StepContainer;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.step.EmbeddedStep;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StepObjectManager
extends AbstractObjectManager<Step, Step> {
    private Map<String, Class<? extends Step>> subclasses;

    @Autowired
    public StepObjectManager(StepRepository repository) {
        super(Step.class, repository);
    }

    @Override
    public void protectedOnRemove(Step object) {
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only StepContainer objects are here")
    public Step create(Storable parent, String type) {
        Step result;
        Class<? extends Step> stepClass = this.subclasses.get(type);
        if (stepClass == null) {
            throw new IllegalArgumentException("Cannot create step of type " + type);
        }
        try {
            result = stepClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Cannot create step of type " + type + " with class " + stepClass.getCanonicalName(), e);
        }
        if (parent != null) {
            result.setParent(parent);
            result.setOrder(((StepContainer)parent).getSteps().size());
            ((StepContainer)parent).getSteps().add(result);
        }
        result = (Step)this.repository.save(result);
        return result;
    }

    @Override
    public Step create() {
        throw new IllegalArgumentException("Cannot create step of unknown type!");
    }

    @PostConstruct
    protected void init() {
        this.subclasses = new HashMap<String, Class<? extends Step>>(){
            {
                this.put("embeddedChainStep", EmbeddedStep.class);
                this.put("integrationStep", IntegrationStep.class);
                this.put("situationStep", SituationStep.class);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only Step objects are here")
    public void afterDelete(Storable object) {
        if (object.getParent() instanceof CallChain) {
            Storable storable = object.getParent();
            synchronized (storable) {
                ((CallChain)object.getParent()).getSteps().remove((Step)object);
            }
        }
    }
}

