/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.executor;

import java.math.BigInteger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.UserDataManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.StubProjectRepository;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.util.config.ApplicationConfig;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.exception.StorageException;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StubProjectObjectManager
extends AbstractObjectManager<StubProject, StubProject>
implements SearchManager<StubProject>,
UserDataManager {
    private static final Logger log = LoggerFactory.getLogger(StubProjectObjectManager.class);
    private final StubProjectRepository stubProjectRepository;

    @Autowired
    public StubProjectObjectManager(StubProjectRepository repository) {
        super(StubProject.class, repository);
        this.stubProjectRepository = repository;
    }

    @Override
    public StubProject create(Storable parent, String type, Map parameters) {
        StubProject project = this.create();
        project.setStorableProp(parameters);
        return project;
    }

    @Override
    public StubProject create() {
        StubProject project = (StubProject)super.create();
        this.prepareRootFolders(project);
        this.createDatasetFolder((BigInteger)project.getID());
        return (StubProject)this.stubProjectRepository.save(project);
    }

    @Override
    public void setReplicationRole(String roleName) {
        if (roleName.equals("replica")) {
            this.stubProjectRepository.setReplicationRoleReplica();
        } else {
            this.stubProjectRepository.setReplicationRoleOrigin();
        }
    }

    @Override
    public String setUserData(String action, String key, String value, BigInteger projectId) {
        if (action == null) {
            return "#set_userdata directive error: 'Action' parameter is null or empty!";
        }
        try {
            return TxExecutor.execute(() -> {
                switch (action) {
                    case "SELECT": {
                        List<String> objs = this.stubProjectRepository.getData(key, projectId);
                        return !objs.isEmpty() ? objs.get(0) : "";
                    }
                    case "INSERT": {
                        this.stubProjectRepository.setData(key, value, projectId);
                        break;
                    }
                    case "UPDATE": {
                        this.stubProjectRepository.updateData(key, value, projectId);
                        break;
                    }
                    case "UPSERT": {
                        this.stubProjectRepository.upsertData(key, value, projectId);
                        break;
                    }
                    case "DELETE": {
                        this.stubProjectRepository.deleteData(key, projectId);
                        break;
                    }
                    default: {
                        return "#set_userdata directive error: Unknown 'Action': " + action + "!";
                    }
                }
                return "";
            }, TxExecutor.nestedWritableTransaction());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String clearUserData(Integer leaveDays) {
        return this.stubProjectRepository.clearUserData(leaveDays);
    }

    @Override
    public BigInteger getEntityInternalIdByUuid(UUID uuid) {
        return this.stubProjectRepository.getEntityInternalIdByUuid(uuid);
    }

    @Override
    public StubProject getByUuid(UUID uuid) {
        return this.stubProjectRepository.getByUuid(uuid);
    }

    @Override
    public Map<String, Object> getProjectIdsBySystem(Object systemId) {
        List<String[]> results = this.stubProjectRepository.determineProjectIdsBySystemId(IdConverter.toBigInt(systemId));
        if (results.isEmpty()) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectId", IdConverter.toBigInt(results.get(0)[0]));
        map.put("projectUuid", UUID.fromString(results.get(0)[1]));
        return map;
    }

    @Override
    @Transactional(readOnly=true)
    public String getProjectSettingByShortName(BigInteger projectId, String propertyShortName) {
        try {
            return this.stubProjectRepository.getProjectSetting(projectId, propertyShortName);
        }
        catch (Exception e) {
            log.warn("Error getting project setting from DB by projectId {} and property name '{}', root cause: {}", new Object[]{projectId, propertyShortName, e.getCause() == null ? e : e.getCause()});
            return "";
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, String> getAllProjectSettingsByProjectId(BigInteger projectId) {
        try {
            List<Object[]> arraysWithProjectSettingsShortNamesAndValues = this.stubProjectRepository.getAllProjectSettingsByProjectId(projectId);
            return this.formatProjectSettingsAsMap(arraysWithProjectSettingsShortNamesAndValues);
        }
        catch (Exception e) {
            log.error("Error getting project settings from DB by projectId {}, root cause: {}", (Object)projectId, (Object)(e.getCause() == null ? e : e.getCause()));
            return new HashMap<String, String>();
        }
    }

    @Override
    @Transactional
    public void updateProjectSetting(@Param(value="projectId") BigInteger projectId, @Param(value="propShortName") String propShortName, @Param(value="propValue") String propValue) {
        this.stubProjectRepository.updateProjectSetting(projectId, propShortName, propValue);
    }

    private Map<String, String> formatProjectSettingsAsMap(List<Object[]> nameValueArrays) {
        HashMap<String, String> projectSettings = new HashMap<String, String>();
        for (Object[] item : nameValueArrays) {
            projectSettings.put(item[0].toString(), item[1] != null ? item[1].toString() : "");
        }
        return projectSettings;
    }

    private void prepareRootFolders(StubProject project) {
        if (project.getEnvironments() == null) {
            project.setEnvironments(this.createRootFolder(project, Environment.class));
        }
        if (project.getCallchains() == null) {
            project.setCallchains(this.createRootFolder(project, CallChain.class));
        }
        if (project.getServers() == null) {
            project.setServers(this.createRootFolder(project, Server.class));
        }
        if (project.getSystems() == null) {
            project.setSystems(this.createRootFolder(project, System.class));
        }
    }

    private <T extends Storable> Folder<T> createRootFolder(StubProject project, Class<T> forClass) {
        Folder result = (Folder)CoreObjectManager.getInstance().getManager(Folder.class).create(null, "ROOT", forClass.getSimpleName()).of(forClass).get();
        result.setProject(project);
        return result;
    }

    private <T extends Storable> Folder<T> createFolder(Storable parent, Class<T> forClass) {
        return (Folder)CoreObjectManager.getInstance().getManager(Folder.class).create(parent, forClass.getSimpleName()).of(forClass).get();
    }

    private void createDatasetFolder(BigInteger projectId) {
        Path newDataSetFolder = Paths.get(Objects.requireNonNull(ApplicationConfig.env.getProperty("working.directory")), "dataset").resolve(String.valueOf(projectId));
        if (!newDataSetFolder.toFile().mkdirs()) {
            throw new StorageException(String.format("DataSet folder for project %d hasn't been created.", projectId));
        }
    }
}

