/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.executor;

import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.NotImplementedException;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.StorableInFolderObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.EnvConfigurationManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.LabeledObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.NativeManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByProjectIdManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.EnvironmentRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.StepRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.SystemRepository;
import org.qubership.automation.itf.core.model.IdNamePair;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.environment.QEnvironment;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.usage.UsageInfo;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemObjectManager
extends AbstractObjectManager<System, System>
implements NativeManager<System>,
LabeledObjectManager<System>,
EnvConfigurationManager<System>,
SearchByProjectIdManager<System>,
StorableInFolderObjectManager {
    private final StepRepository stepRepository;
    private final EnvironmentRepository environmentRepository;
    private final SystemRepository systemRepository;

    @Autowired
    public SystemObjectManager(SystemRepository repository, StepRepository stepRepository, EnvironmentRepository environmentRepository) {
        super(System.class, repository);
        this.systemRepository = repository;
        this.stepRepository = stepRepository;
        this.environmentRepository = environmentRepository;
    }

    @Override
    public void protectedOnRemove(System object) {
        this.stepRepository.onDeleteSystemSender(object);
        this.stepRepository.onDeleteSystemReceiver(object);
        Iterable environments = this.environmentRepository.findAll((Predicate)QEnvironment.environment.outbound.containsKey((Object)object));
        for (Environment environment : environments) {
            environment.getOutbound().remove(object);
            environment.store();
        }
        environments = this.environmentRepository.findAll((Predicate)QEnvironment.environment.inbound.containsKey((Object)object));
        for (Environment environment : environments) {
            environment.getInbound().remove(object);
            environment.store();
        }
    }

    @Override
    public Collection<UsageInfo> findUsages(Storable storable) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)500);
        if (storable instanceof System) {
            System system = (System)storable;
            Iterable<Step> stepsWithSender = this.stepRepository.getIntegrationStepsBySender(system);
            SystemObjectManager.addToUsages(result, "Sender", stepsWithSender);
            Iterable<Step> stepsWithReceiver = this.stepRepository.getIntegrationStepsByReceiver(system);
            SystemObjectManager.addToUsages(result, "Receiver", stepsWithReceiver);
            Iterable envsOut = this.environmentRepository.findAll((Predicate)QEnvironment.environment.outbound.containsKey((Object)system));
            SystemObjectManager.addToUsages(result, "Outbound", envsOut);
            Iterable envsIn = this.environmentRepository.findAll((Predicate)QEnvironment.environment.inbound.containsKey((Object)system));
            SystemObjectManager.addToUsages(result, "Inbound", envsIn);
        }
        return result;
    }

    @Override
    public Map<String, List<BigInteger>> findImportantChildren(Storable storable) {
        if (storable instanceof System) {
            BigInteger id = IdConverter.toBigInt(storable.getID());
            List<BigInteger> stubTriggerIds = this.systemRepository.getTransportTriggersBySystemId(id);
            List<BigInteger> seTriggerIds = this.systemRepository.getSituationEventTriggersBySystemId(id);
            HashMap<String, List<BigInteger>> result = new HashMap<String, List<BigInteger>>();
            result.put("TransportTriggers", stubTriggerIds);
            result.put("SituationEventTriggers", seTriggerIds);
            return result;
        }
        return super.findImportantChildren(storable);
    }

    @Override
    public Storable getChildByClass(System parent, Class childrenClass, Object ... param) {
        if (childrenClass.getName().equals(Operation.class.getName()) && param[0] != null) {
            return this.systemRepository.findFirstByDefineOperation(IdConverter.toBigInt(parent.getID()), String.valueOf(param[0]));
        }
        throw new NotImplementedException("Not implemented for classes other than " + Operation.class.getName());
    }

    @Override
    public Collection<? extends Storable> getChildrenByClass(System parent, Class childrenClass, Object ... param) {
        throw new NotImplementedException("");
    }

    @Override
    public Collection<System> getByLabel(String label) {
        throw new NotImplementedException("Method getByLabel is not implemented");
    }

    @Override
    public Collection<System> getByLabel(String label, BigInteger projectId) {
        throw new NotImplementedException("Method getByLabel is not implemented");
    }

    @Override
    public Set<String> getAllLabels(BigInteger projectId) {
        return TxExecutor.executeUnchecked(() -> this.systemRepository.getAllLabels(projectId), TxExecutor.readOnlyTransaction());
    }

    @Override
    public System getByEcId(@Nonnull String ecId, Object ... objects) {
        return TxExecutor.executeUnchecked(() -> this.systemRepository.findSystemByEcId(ecId), TxExecutor.defaultWritableTransaction());
    }

    @Override
    public Collection<System> getByEcProjectId(String ecProjectId) {
        return TxExecutor.executeUnchecked(() -> this.systemRepository.getSystemsByEcProject(ecProjectId), TxExecutor.defaultWritableTransaction());
    }

    @Override
    public Collection<String> getEcProjectIds(BigInteger projectId) {
        return TxExecutor.executeUnchecked(() -> this.systemRepository.getEcProjectIds(projectId), TxExecutor.defaultWritableTransaction());
    }

    @Override
    public void unbindByEcProject(String ecProjectId) {
        TxExecutor.executeUnchecked(() -> this.systemRepository.unbindByEcProject(ecProjectId), TxExecutor.defaultWritableTransaction());
    }

    @Override
    public System findByEcLabel(String ecLabel, BigInteger projectId) {
        return TxExecutor.executeUnchecked(() -> this.systemRepository.findByEcLabel(ecLabel, projectId), TxExecutor.defaultWritableTransaction());
    }

    public Collection<System> getByPieceOfNameAndProject(String name, Object projectId) {
        return this.systemRepository.findByPieceOfNameAndProject(name, IdConverter.toBigInt(projectId));
    }

    @Override
    public Collection<System> getByProjectId(BigInteger projectId) {
        return this.systemRepository.findByProject(projectId);
    }

    public List<IdNamePair> getSimpleListByProject(Object projectId) {
        return ((SystemRepository)this.repository).getSimpleListByProject(IdConverter.toBigInt(projectId));
    }

    @Override
    public List<System> getReceiverSystemsFromCallChainSteps(Object chainId) {
        List<BigInteger> ids = this.systemRepository.getReceiverSystemIdsFromCallChainSteps(IdConverter.toBigInt(chainId));
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<System>();
        }
        ArrayList<System> systems = new ArrayList<System>();
        for (BigInteger id : ids) {
            System system;
            if (id == null || (system = (System)this.systemRepository.getOne(id)) == null) continue;
            systems.add(system);
        }
        return systems;
    }

    @Override
    public void afterDelete(Storable object) {
        this.afterDeleteFromFolder(object);
    }
}

