/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.executor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import javax.persistence.QueryHint;
import org.javers.spring.annotation.JaversSpringDataAuditable;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.EventTriggerRepository;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.OperationEventTrigger;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
@JaversSpringDataAuditable
public interface OperationEventTriggerRepository
extends EventTriggerRepository<OperationEventTrigger> {
    @Query(value="select trigger from OperationEventTrigger trigger where trigger.parent in (    select situation from Situation situation where situation.parent = :operation) order by priority asc")
    public Collection<OperationEventTrigger> getTriggersByOperation(@Param(value="operation") Operation var1);

    @Query(value="select trigger from OperationEventTrigger trigger inner join Situation as situation on situation = trigger.parent inner join Operation as operation on operation = situation.parent where operation.projectId = :projectId")
    public Collection<OperationEventTrigger> findByProject(@Param(value="projectId") BigInteger var1);

    @Query(value="select trg.* from mb_triggers trg inner join mb_situation sit on sit.id = trg.oet_parent_id inner join mb_operations op on op.id = sit.parent_id where trg.parent_type = 'operation' and trg.state = 'ACTIVE' and op.project_id = :projectId", nativeQuery=true)
    public List<OperationEventTrigger> getActiveTriggersByProject(@Param(value="projectId") BigInteger var1);

    @Query(value="select trg.* from mb_triggers trg where trg.oet_parent_id in (    select id from mb_situation where parent_id = :operationId) and trg.parent_type = 'operation' and trg.state = 'ACTIVE' order by trg.priority asc", nativeQuery=true)
    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.cacheRegion", value="activeOperationEventTriggersCache")})
    public List<OperationEventTrigger> getActiveTriggersByOperationNative(@Param(value="operationId") BigInteger var1);

    @Query(value="select trg.id from mb_triggers trg where trg.oet_parent_id in (:situationIds) and trg.parent_type = 'operation' and trg.state = 'ACTIVE'", nativeQuery=true)
    public List<BigInteger> getActiveTriggersBySituationIdsNative(@Param(value="situationIds") List<BigInteger> var1);

    @Query(value="select trigger from OperationEventTrigger trigger where trigger.state = 'ACTIVE' and trigger.parent in (    select situation.id from Situation situation where situation.parent = :operation) order by priority asc")
    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.cacheRegion", value="activeOperationEventTriggersCache")})
    public List<OperationEventTrigger> getActiveTriggersByOperation(@Param(value="operation") Operation var1);

    @Query(value="select trigger from OperationEventTrigger as trigger where id = :id")
    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.cacheRegion", value="operationEventTriggerCache")})
    public OperationEventTrigger findByIdOnly(@Param(value="id") BigInteger var1);
}

