/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.context;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.context.JsonStorable;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractContainerInstance;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.util.annotation.JsonRef;
import org.qubership.automation.itf.core.util.constants.StartedFrom;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.helper.FailTimeOut;
import org.qubership.automation.itf.core.util.helper.StorableUtils;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.services.CoreServices;

@JsonInclude
@JsonFormat(shape=JsonFormat.Shape.OBJECT)
@Entity
@JsonFilter(value="reportWorkerFilter_TCContext")
public class TcContext
extends JsonStorable {
    private static final long serialVersionUID = 20240812L;
    public static final String TC = "tc";
    private static final transient DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yy HH:mm:ss.SSS").withZone(ZoneId.systemDefault()).withLocale(Locale.ENGLISH);
    BigInteger environmentId;
    private String environmentName;
    private List<AbstractContainerInstance> instances = Lists.newArrayListWithExpectedSize((int)20);
    private AbstractContainerInstance initiator;
    private BigInteger projectId;
    private UUID projectUuid;
    private Status status = Status.NOT_STARTED;
    private Set<String> bindingKeys = Sets.newHashSet();
    private Map<String, String> reportLinks = Maps.newHashMapWithExpectedSize((int)5);
    private boolean startedByAtp;
    private boolean needToReportToAtp;
    private boolean needToReportToItf;
    private boolean startValidation;
    private StartedFrom startedFrom;
    private boolean runStepByStep;
    private String client;
    private boolean validationFailed;
    private Date endTime;
    private transient boolean isFailEventSent;
    private transient boolean isFinishEventSent;
    private transient boolean isNotified;
    private long lastUpdateTime = 0L;
    private long timeToLive = 0L;
    private String podName = null;
    private int partNum;

    public void setTimeToLive() {
        this.timeToLive = FailTimeOut.getTimeout(this.projectId);
    }

    public TcContext() {
        Date crDate = new Date();
        this.setName("Context created at " + crDate.toInstant().atZone(ZoneId.systemDefault()).format(dateTimeFormatter));
        this.setStartTime(crDate);
        this.isFailEventSent = false;
        this.isFinishEventSent = false;
        this.isNotified = false;
    }

    public TcContext(Storable parent, Map parameters) {
        this();
    }

    public void fillBindingKeys(Set<String> renderendContextKeys) {
        StorableUtils.fillCollection(this.getBindingKeys(), renderendContextKeys);
    }

    public void fillReportLinks(Map<String, String> reportLinks) {
        StorableUtils.fillMap(this.getReportLinks(), reportLinks);
    }

    public boolean isRunning() {
        return Status.IN_PROGRESS.equals((Object)this.status);
    }

    public boolean isRunnable() {
        return Status.NOT_STARTED.equals((Object)this.status) || Status.PAUSED.equals((Object)this.status);
    }

    public boolean isFinished() {
        return Status.PASSED.equals((Object)this.status) || Status.FAILED.equals((Object)this.status) || Status.STOPPED.equals((Object)this.status) || Status.FAILED_BY_TIMEOUT.equals((Object)this.status);
    }

    @JsonIgnore
    public List<AbstractContainerInstance> getInstances() {
        return this.instances;
    }

    protected void setInstances(List<AbstractContainerInstance> instances) {
        this.instances = instances;
    }

    public void fillInstances(List<AbstractContainerInstance> instances) {
        StorableUtils.fillCollection(this.getInstances(), instances);
    }

    @JsonRef
    public AbstractContainerInstance getInitiator() {
        return this.initiator;
    }

    public void setInitiator(AbstractContainerInstance initiator) {
        this.initiator = initiator;
    }

    @Transient
    @JsonIgnore
    public Date getDuration() {
        return new Date(this.endTime == null || this.startTime == null ? System.currentTimeMillis() : this.endTime.getTime() - this.startTime.getTime());
    }

    @Transient
    @JsonIgnore
    public int getDurationMinutes() {
        if (this.startTime == null) {
            return 0;
        }
        if (this.endTime == null) {
            return (int)((System.currentTimeMillis() - this.startTime.getTime()) / 60000L + 1L);
        }
        return (int)((this.endTime.getTime() - this.startTime.getTime()) / 60000L + 1L);
    }

    @Transient
    @JsonIgnore
    public boolean isStartValidation() {
        return this.startValidation;
    }

    public void setStartValidation(boolean startValidation) {
        this.startValidation = startValidation;
    }

    @Transient
    @JsonIgnore
    public Environment getEnvironmentById() {
        return CoreObjectManager.getInstance().getManager(Environment.class).getById(this.getEnvironmentId());
    }

    @Transient
    @JsonIgnore
    public boolean getStartedByAtp() {
        return this.startedByAtp;
    }

    public void setStartedByAtp(boolean startedByAtp) {
        this.startedByAtp = startedByAtp;
    }

    public boolean isNeedToReportToAtp() {
        return this.needToReportToAtp;
    }

    public void setNeedToReportToAtp(boolean needToReportToAtp) {
        this.needToReportToAtp = needToReportToAtp;
    }

    @Transient
    @JsonIgnore
    public boolean isNeedToReportToItf() {
        return this.needToReportToItf;
    }

    public void setNeedToReportToItf(boolean needToReportToItf) {
        this.needToReportToItf = needToReportToItf;
    }

    public void setAndCalculateNeedToReportToItf() {
        if (this.getInitiator() instanceof SituationInstance) {
            this.setNeedToReportToItf(true);
        } else if (StartedFrom.RAM2.equals((Object)this.getStartedFrom()) || StartedFrom.ATP.equals((Object)this.getStartedFrom()) || this.getStartedByAtp()) {
            this.setNeedToReportToItf(Boolean.parseBoolean(CoreServices.getProjectSettingsService().get(this.getProjectId(), "enable.itf.reporting", "false")));
        } else {
            this.setNeedToReportToItf(true);
        }
    }

    @Transient
    @JsonIgnore
    public StartedFrom getStartedFrom() {
        return this.startedFrom;
    }

    public void setStartedFrom(StartedFrom startedFrom) {
        this.startedFrom = startedFrom;
    }

    @Transient
    @JsonIgnore
    public Boolean isFailEventSent() {
        return this.isFailEventSent;
    }

    public void setFailEventAsSent() {
        this.isFailEventSent = true;
    }

    @Transient
    @JsonIgnore
    public Boolean isFinishEventSent() {
        return this.isFinishEventSent;
    }

    public void setFinishEventAsSent() {
        this.isFinishEventSent = true;
    }

    @Transient
    @JsonIgnore
    public boolean isNotified() {
        return this.isNotified;
    }

    public void setNotified(boolean notified) {
        this.isNotified = notified;
    }

    @Override
    public boolean equals(Object anObject) {
        if (anObject instanceof TcContext) {
            return this.getID().toString().equals(((TcContext)anObject).getID().toString());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getID());
    }

    public boolean isRunStepByStep() {
        return this.runStepByStep;
    }

    public void setRunStepByStep(boolean runStepByStep) {
        this.runStepByStep = runStepByStep;
    }

    public boolean isValidationFailed() {
        return this.validationFailed;
    }

    public void setValidationFailed(boolean validationFailed) {
        this.validationFailed = validationFailed;
    }

    public BigInteger getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(BigInteger environmentId) {
        this.environmentId = environmentId;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    @Override
    public void setProjectId(BigInteger projectId) {
        this.projectId = projectId;
    }

    @Override
    public BigInteger getProjectId() {
        return this.projectId;
    }

    public void setProjectUuid(UUID projectUuid) {
        this.projectUuid = projectUuid;
    }

    public UUID getProjectUuid() {
        return this.projectUuid;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    protected void setBindingKeys(Set<String> bindingKeys) {
        this.bindingKeys = bindingKeys;
    }

    public Set<String> getBindingKeys() {
        return this.bindingKeys;
    }

    protected void setReportLinks(Map<String, String> reportLinks) {
        this.reportLinks = reportLinks;
    }

    public Map<String, String> getReportLinks() {
        return this.reportLinks;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getClient() {
        return this.client;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public String getPodName() {
        return this.podName;
    }

    public void setPodName(String podName) {
        this.podName = podName;
    }

    public int getPartNum() {
        return this.partNum;
    }

    public void setPartNum(int partNum) {
        this.partNum = partNum;
    }
}

