/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.context;

import java.math.BigInteger;
import java.util.Date;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.storage.AbstractStorable;
import org.qubership.automation.itf.core.util.annotation.ProduceNewObject;
import org.qubership.automation.itf.core.util.constants.Status;

@Entity
public class TcContextBriefInfo
extends AbstractStorable {
    private static final long serialVersionUID = 20240812L;
    Object id;
    private String name;
    private Object environment;
    private String envname;
    private String operationName;
    private BigInteger systemId = null;
    private String systemName;
    private Object initiator;
    private String ininame;
    private Status status = Status.NOT_STARTED;
    private Date startTime;
    private Date endTime;
    private Long duration;
    private String client;
    private String initiatortype;
    private BigInteger situationId = null;
    private BigInteger chainId = null;
    private String jsonstring;
    private String executiondata;
    private BigInteger projectId;
    private Integer partNum;

    public TcContextBriefInfo() {
    }

    public TcContextBriefInfo(TcContext ctx) {
        this.id = ctx.getID();
        this.name = ctx.getName();
        this.status = ctx.getStatus();
        this.startTime = ctx.getStartTime();
        this.endTime = ctx.getEndTime();
        if (ctx.getEnvironmentId() != null) {
            this.environment = ctx.getEnvironmentId();
            this.envname = ctx.getEnvironmentName();
        } else {
            this.environment = null;
            this.envname = "";
        }
        if (ctx.getInitiator() != null) {
            this.initiator = ctx.getInitiator().getID();
            this.ininame = ctx.getInitiator().getName();
            if (ctx.getInitiator() instanceof SituationInstance) {
                this.initiatortype = "SituationInstance";
                this.situationId = ((SituationInstance)ctx.getInitiator()).getSituationId();
            } else {
                this.initiatortype = "CallChainInstance";
                this.chainId = ((CallChainInstance)ctx.getInitiator()).getTestCaseId();
            }
        } else {
            this.initiator = null;
            this.ininame = "";
        }
        this.projectId = ctx.getProjectId();
    }

    public TcContextBriefInfo(Object[] object) {
        if (object.length != 14) {
            throw new IllegalArgumentException("Object isn't correct. Object has " + object.length + " elements (required: 14).");
        }
        this.setID(object[0]);
        if (object[1] != null) {
            this.setName(object[1].toString());
        }
        this.setInitiator(object[2]);
        this.setEnvironment(object[3]);
        if (object[4] != null) {
            this.setStatus(Status.valueOf(object[4].toString()));
        }
        if (object[5] != null) {
            this.setStartTime((Date)object[5]);
        }
        if (object[6] != null) {
            this.setEndTime((Date)object[6]);
        }
        if (object[7] != null) {
            this.setJsonstring(object[7].toString());
        }
        if (object[8] != null) {
            this.setProjectId((BigInteger)object[8]);
        }
        if (object[9] != null) {
            this.setIniname(object[9].toString());
        }
        if (object[10] != null) {
            this.setInitiatortype(object[10].toString());
        }
        this.setSituationId((BigInteger)object[11]);
        this.setChainId((BigInteger)object[12]);
        if (object[13] != null) {
            this.setExecutiondata(object[13].toString());
        }
    }

    @Override
    @ProduceNewObject
    public Object getNaturalId() {
        return super.getNaturalId();
    }

    public Object getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Object getEnvironment() {
        return this.environment;
    }

    public String getEnvname() {
        return this.envname;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public BigInteger getSystemId() {
        return this.systemId;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public Object getInitiator() {
        return this.initiator;
    }

    public String getIniname() {
        return this.ininame;
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Long getDuration() {
        return this.duration;
    }

    public String getClient() {
        return this.client;
    }

    public String getInitiatortype() {
        return this.initiatortype;
    }

    public BigInteger getSituationId() {
        return this.situationId;
    }

    public BigInteger getChainId() {
        return this.chainId;
    }

    public String getJsonstring() {
        return this.jsonstring;
    }

    public String getExecutiondata() {
        return this.executiondata;
    }

    @Override
    public BigInteger getProjectId() {
        return this.projectId;
    }

    public Integer getPartNum() {
        return this.partNum;
    }

    public void setId(Object id) {
        this.id = id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setEnvironment(Object environment) {
        this.environment = environment;
    }

    public void setEnvname(String envname) {
        this.envname = envname;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public void setSystemId(BigInteger systemId) {
        this.systemId = systemId;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public void setInitiator(Object initiator) {
        this.initiator = initiator;
    }

    public void setIniname(String ininame) {
        this.ininame = ininame;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public void setInitiatortype(String initiatortype) {
        this.initiatortype = initiatortype;
    }

    public void setSituationId(BigInteger situationId) {
        this.situationId = situationId;
    }

    public void setChainId(BigInteger chainId) {
        this.chainId = chainId;
    }

    public void setJsonstring(String jsonstring) {
        this.jsonstring = jsonstring;
    }

    public void setExecutiondata(String executiondata) {
        this.executiondata = executiondata;
    }

    @Override
    public void setProjectId(BigInteger projectId) {
        this.projectId = projectId;
    }

    public void setPartNum(Integer partNum) {
        this.partNum = partNum;
    }
}

