/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.instance.step;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.SpContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractContainerInstance;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.constants.Mep;

@Entity
@JsonFilter(value="reportWorkerFilter_StepInstance")
public class StepInstance
extends AbstractInstance {
    private static final long serialVersionUID = 20240812L;
    private BigInteger stepId;
    private Step step;
    private int currentValidAttemptValue;
    private int currentCondAttemptValue;
    private boolean isRetryStep;

    public StepInstance() {
        this.getContext().setSP(new SpContext(this));
    }

    @Override
    public Storable getSource() {
        return this.step;
    }

    public void init(Step step) {
        this.stepId = (BigInteger)step.getID();
        this.step = step;
        this.setName(step.getName());
        this.getContext().setSP(new SpContext(this));
    }

    public void init(Step step, InstanceContext context, SpContext spContext) {
        this.stepId = (BigInteger)step.getID();
        this.step = step;
        this.getContext().putAll((Map)context);
        if (spContext == null) {
            spContext = new SpContext(this);
        }
        this.getContext().setSP(spContext);
        this.getContext().sp().setParent(this.getContext());
        this.getContext().setProjectUuid(context.getProjectUuid());
    }

    @Transient
    @JsonIgnore
    public Step getStep() {
        return this.step;
    }

    public void setStep(Step step) {
        this.step = step;
    }

    public void setStepId(BigInteger stepId) {
        this.stepId = stepId;
    }

    public BigInteger getStepId() {
        return this.stepId;
    }

    @Override
    public AbstractContainerInstance getParent() {
        return (AbstractContainerInstance)super.getParent();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof StepInstance && (obj == this || ((StepInstance)obj).getParent() == this.getParent() && ((StepInstance)obj).getStepId().equals(this.stepId));
    }

    @Override
    public int hashCode() {
        return ("StepInstance" + this.getParent().getID() + this.stepId).hashCode();
    }

    @JsonIgnore
    public Mep getMep() {
        return this.getStep() == null ? null : this.getStep().getMep();
    }

    @JsonIgnore
    public Message getIncomingMessage() {
        return this.getContext().sp().getIncomingMessage();
    }

    public void setIncomingMessage(Message incomingMessage) {
        this.getContext().sp().setIncomingMessage(incomingMessage);
    }

    @JsonIgnore
    public Message getOutgoingMessage() {
        return this.getContext().sp().getOutgoingMessage();
    }

    public void setOutgoingMessage(Message outgoingMessage) {
        this.getContext().sp().setOutgoingMessage(outgoingMessage);
    }

    @JsonIgnore
    public int getCurrentValidAttemptValue() {
        return this.currentValidAttemptValue;
    }

    public void setCurrentValidAttemptValue(int currentValidAttemptValue) {
        this.currentValidAttemptValue = currentValidAttemptValue;
    }

    @JsonIgnore
    public int getCurrentCondAttemptValue() {
        return this.currentCondAttemptValue;
    }

    public void setCurrentCondAttemptValue(int currentCondAttemptValue) {
        this.currentCondAttemptValue = currentCondAttemptValue;
    }

    @JsonIgnore
    public boolean isRetryStep() {
        return this.isRetryStep;
    }

    public void setIsRetryStep(boolean isRetryStep) {
        this.isRetryStep = isRetryStep;
    }

    @Override
    public Map<String, String> getTransportConfiguration() {
        TransportConfiguration transportConfiguration;
        HashMap<String, String> transportConfigurationMap = new HashMap<String, String>();
        if (this.getStep() != null && ((IntegrationStep)this.getStep()).getOperation() != null && (transportConfiguration = ((IntegrationStep)this.getStep()).getOperation().getTransport()) != null) {
            transportConfigurationMap.put("transportName", transportConfiguration.getName());
            transportConfigurationMap.put("transportType", transportConfiguration.getTypeName().replaceAll("\\w+\\.", ""));
            transportConfigurationMap.put("transportMEP", transportConfiguration.getMep().toString());
        }
        return transportConfigurationMap;
    }
}

