/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.project;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.util.Set;
import java.util.UUID;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.IDataSetListManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.dataset.DataSetList;
import org.qubership.automation.itf.core.model.dataset.DataSetListsSource;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.folder.ChainFolder;
import org.qubership.automation.itf.core.model.jpa.folder.EnvFolder;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.folder.ServerFolder;
import org.qubership.automation.itf.core.model.jpa.folder.SystemFolder;
import org.qubership.automation.itf.core.model.jpa.project.IntegrationConfig;
import org.qubership.automation.itf.core.model.jpa.project.StubContainer;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.storage.AbstractStorable;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.util.ei.deserialize.ChainFolderDeserializer;
import org.qubership.automation.itf.core.util.ei.deserialize.EnvFolderDeserializer;
import org.qubership.automation.itf.core.util.ei.deserialize.ServerFolderDeserializer;
import org.qubership.automation.itf.core.util.ei.deserialize.SystemFolderDeserializer;
import org.qubership.automation.itf.core.util.ei.serialize.IdSerializer;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=StubProject.class)
public class StubProject
extends AbstractStorable
implements StubContainer {
    private static final long serialVersionUID = 20240812L;
    private SystemFolder systems;
    private ChainFolder callchains;
    private EnvFolder environments;
    private ServerFolder servers;
    private Folder<DataSetListsSource> dataSetLists;
    private Set<IntegrationConfig> integrationConfs = Sets.newHashSet();
    private UUID uuid;

    @Override
    @JsonSerialize(using=IdSerializer.class)
    public Folder<System> getSystems() {
        return this.systems;
    }

    @Override
    @JsonDeserialize(using=SystemFolderDeserializer.class)
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void setSystems(Folder<System> systems) {
        this.systems = (SystemFolder)systems;
    }

    @Override
    @JsonSerialize(using=IdSerializer.class)
    public Folder<Environment> getEnvironments() {
        return this.environments;
    }

    @Override
    @JsonDeserialize(using=EnvFolderDeserializer.class)
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void setEnvironments(Folder<Environment> environments) {
        this.environments = (EnvFolder)environments;
    }

    @Override
    @JsonSerialize(using=IdSerializer.class)
    public Folder<Server> getServers() {
        return this.servers;
    }

    @Override
    @JsonDeserialize(using=ServerFolderDeserializer.class)
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void setServers(Folder<Server> servers) {
        this.servers = (ServerFolder)servers;
    }

    @Override
    @JsonIgnore
    public Folder<DataSetListsSource> getDataSetLists() {
        return CoreObjectManager.getInstance().getSpecialManager(DataSetList.class, IDataSetListManager.class).getFolder();
    }

    @Override
    @Deprecated
    public void setDataSetLists(Folder<DataSetListsSource> dataSetLists) {
    }

    @Override
    @JsonSerialize(using=IdSerializer.class)
    public Folder<CallChain> getCallchains() {
        return this.callchains;
    }

    @Override
    @JsonDeserialize(using=ChainFolderDeserializer.class)
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void setCallchains(Folder<CallChain> callchains) {
        this.callchains = (ChainFolder)callchains;
    }

    @Override
    public Storable findRootObject(BigInteger projectId) {
        return CoreObjectManager.getInstance().getManager(StubProject.class).getById(projectId);
    }

    @Override
    public BigInteger getProjectId() {
        return (BigInteger)this.getID();
    }

    public Set<IntegrationConfig> getIntegrationConfs() {
        return this.integrationConfs;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setIntegrationConfs(Set<IntegrationConfig> integrationConfs) {
        this.integrationConfs = integrationConfs;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }
}

