/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.step;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.Transient;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.model.jpa.storage.AbstractStorable;

public abstract class AbstractStep
extends AbstractStorable
implements Step {
    private boolean enabled = true;
    private boolean manual = false;
    private long delay;
    private String unit = TimeUnit.SECONDS.toString();
    private int order;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isManual() {
        return this.manual;
    }

    @Override
    public void setManual(boolean manual) {
        this.manual = manual;
    }

    @Override
    public long getDelay() {
        return this.delay;
    }

    @Override
    public void setDelay(long delay) {
        this.delay = delay;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public void setUnit(String unit) {
        this.unit = AbstractStep.checkUnit(unit);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    @Transient
    @JsonIgnore
    public TimeUnit retrieveUnit() {
        return AbstractStep.convertToTimeUnit(this.unit);
    }

    public static String checkUnit(String unitName) {
        if (StringUtils.isBlank((CharSequence)unitName)) {
            return null;
        }
        try {
            TimeUnit test = TimeUnit.valueOf(unitName);
            return test.toString();
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static TimeUnit convertToTimeUnit(String unitName) {
        if (StringUtils.isBlank((CharSequence)unitName)) {
            return null;
        }
        try {
            return TimeUnit.valueOf(unitName);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }
}

