/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.stub.fast;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.qubership.automation.itf.core.model.jpa.message.parser.AbstractParsingRule;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.stub.fast.FastConfigurationRequest;
import org.qubership.automation.itf.core.stub.fast.ResponseDescription;
import org.qubership.automation.itf.core.stub.parser.SimpleParsingRule;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StubEndpointConfig
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(StubEndpointConfig.class);
    private static final long serialVersionUID = 20250303L;
    private String configuredEndpoint;
    private String operationDefinitionScript;
    @JsonIgnore
    private String operationDefinitionKey;
    private ResponseDescription defaultResponse;
    private List<ResponseDescription> conditionalResponses;
    private List<SimpleParsingRule> parsingRules;
    private Map<String, List<SimpleParsingRule>> operationParsingRules = new HashMap<String, List<SimpleParsingRule>>();
    private Boolean skipReporting;
    private Boolean disabled;

    public StubEndpointConfig(FastConfigurationRequest.FastSystem fastSystem, FastConfigurationRequest.FastOperation fastOperation, Operation storableOperation, TransportTypes transportType, String endPoint) {
        this.skipReporting = false;
        this.disabled = false;
        this.configuredEndpoint = endPoint;
        this.operationDefinitionScript = fastSystem.getStorableSystem().getOperationKeyDefinition();
        this.parsingRules = new LinkedList<SimpleParsingRule>();
        this.conditionalResponses = new LinkedList<ResponseDescription>();
        Instant start = Instant.now();
        fastSystem.getStorableSystem().getSystemParsingRules().forEach(systemParsingRule -> this.parsingRules.add(new SimpleParsingRule((AbstractParsingRule<?>)systemParsingRule)));
        this.addResponses(fastOperation, storableOperation, transportType);
        log.debug("StubEndpointConfig processed in {} millis", (Object)ChronoUnit.MILLIS.between(start, Instant.now()));
    }

    protected void addResponses(FastConfigurationRequest.FastOperation fastOperation, Operation storableOperation, TransportTypes transportType) {
        ArrayList parsingRulesFromOperation = new ArrayList();
        storableOperation.getOperationParsingRules().forEach(operationParsingRule -> parsingRulesFromOperation.add(new SimpleParsingRule((AbstractParsingRule<?>)operationParsingRule)));
        if (!parsingRulesFromOperation.isEmpty()) {
            this.operationParsingRules.put(storableOperation.getOperationDefinitionKey(), parsingRulesFromOperation);
        }
        LinkedList<ResponseDescription> orderedConditionalResponses = new LinkedList<ResponseDescription>();
        for (FastConfigurationRequest.FastSituation fastSituation : fastOperation.getSituations()) {
            Situation storableSituation = CoreObjectManager.getInstance().getManager(Situation.class).getById(fastSituation.getId());
            if (storableSituation == null) continue;
            if (storableSituation.getSteps().isEmpty()) {
                log.warn("Situation id={} is skipped because doesn't have steps", storableSituation.getID());
                continue;
            }
            ResponseDescription responseDescription = new ResponseDescription(storableSituation, transportType);
            orderedConditionalResponses.add(responseDescription);
        }
        orderedConditionalResponses.sort(Comparator.comparing(ResponseDescription::getPriority));
        this.conditionalResponses.addAll(orderedConditionalResponses);
    }

    public String getConfiguredEndpoint() {
        return this.configuredEndpoint;
    }

    public String getOperationDefinitionScript() {
        return this.operationDefinitionScript;
    }

    public String getOperationDefinitionKey() {
        return this.operationDefinitionKey;
    }

    public ResponseDescription getDefaultResponse() {
        return this.defaultResponse;
    }

    public List<ResponseDescription> getConditionalResponses() {
        return this.conditionalResponses;
    }

    public List<SimpleParsingRule> getParsingRules() {
        return this.parsingRules;
    }

    public Map<String, List<SimpleParsingRule>> getOperationParsingRules() {
        return this.operationParsingRules;
    }

    public Boolean getSkipReporting() {
        return this.skipReporting;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setConfiguredEndpoint(String configuredEndpoint) {
        this.configuredEndpoint = configuredEndpoint;
    }

    public void setOperationDefinitionScript(String operationDefinitionScript) {
        this.operationDefinitionScript = operationDefinitionScript;
    }

    public void setOperationDefinitionKey(String operationDefinitionKey) {
        this.operationDefinitionKey = operationDefinitionKey;
    }

    public void setDefaultResponse(ResponseDescription defaultResponse) {
        this.defaultResponse = defaultResponse;
    }

    public void setConditionalResponses(List<ResponseDescription> conditionalResponses) {
        this.conditionalResponses = conditionalResponses;
    }

    public void setParsingRules(List<SimpleParsingRule> parsingRules) {
        this.parsingRules = parsingRules;
    }

    public void setOperationParsingRules(Map<String, List<SimpleParsingRule>> operationParsingRules) {
        this.operationParsingRules = operationParsingRules;
    }

    public void setSkipReporting(Boolean skipReporting) {
        this.skipReporting = skipReporting;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public StubEndpointConfig() {
    }

    public static enum TransportTypes {
        REST("org.qubership.automation.itf.transport.rest.inbound.RESTInboundTransport"),
        SOAP("org.qubership.automation.itf.transport.soap.http.inbound.SOAPOverHTTPInboundTransport");

        private final String fullTransportType;

        private TransportTypes(String fullTransportType) {
            this.fullTransportType = fullTransportType;
        }

        public String getFullTransportType() {
            return this.fullTransportType;
        }
    }
}

