/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.template.velocity.directives;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.RSASSASigner;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.zip.CRC32;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;

public class ComputeHash
extends Directive {
    public String getName() {
        return "hashsum";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        String content;
        String algorithm;
        String encoding = "UTF-8";
        String key = null;
        Boolean encodeToBase64 = null;
        int paramsCount = node.jjtGetNumChildren();
        switch (paramsCount) {
            case 1: {
                algorithm = "SHA-1";
                content = this.getString(node.jjtGetChild(0), internalContextAdapter);
                break;
            }
            case 2: {
                algorithm = this.getString(node.jjtGetChild(0), internalContextAdapter);
                content = this.getString(node.jjtGetChild(1), internalContextAdapter);
                break;
            }
            case 3: {
                algorithm = this.getString(node.jjtGetChild(0), internalContextAdapter);
                content = this.getString(node.jjtGetChild(1), internalContextAdapter);
                encoding = this.getString(node.jjtGetChild(2), internalContextAdapter);
                break;
            }
            case 4: {
                algorithm = this.getString(node.jjtGetChild(0), internalContextAdapter);
                content = this.getString(node.jjtGetChild(1), internalContextAdapter);
                encoding = this.getString(node.jjtGetChild(2), internalContextAdapter);
                key = this.getString(node.jjtGetChild(3), internalContextAdapter);
                encodeToBase64 = false;
                break;
            }
            case 5: {
                algorithm = this.getString(node.jjtGetChild(0), internalContextAdapter);
                content = this.getString(node.jjtGetChild(1), internalContextAdapter);
                encoding = this.getString(node.jjtGetChild(2), internalContextAdapter);
                key = this.getString(node.jjtGetChild(3), internalContextAdapter);
                encodeToBase64 = Boolean.parseBoolean(this.getString(node.jjtGetChild(4), internalContextAdapter));
                break;
            }
            default: {
                this.rsvc.getLog().warn((Object)("Incorrect format. " + ComputeHash.getExceptionMessage()));
                return true;
            }
        }
        if (algorithm != null && content != null) {
            writer.append(this.computeHash(algorithm.toUpperCase(), content, encoding, key, encodeToBase64));
        }
        return true;
    }

    private String getString(Node node, InternalContextAdapter internalContextAdapter) {
        return node != null ? String.valueOf(node.value(internalContextAdapter)) : null;
    }

    private String computeHash(String algorithm, String content, String encoding, String key, Boolean encodeToBase64) throws UnsupportedEncodingException, IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        switch (algorithm) {
            case "SHA-1": {
                return DigestUtils.sha1Hex((byte[])content.getBytes(encoding));
            }
            case "SHA-256": {
                return DigestUtils.sha256Hex((byte[])content.getBytes(encoding));
            }
            case "SHA-384": {
                return DigestUtils.sha384Hex((byte[])content.getBytes(encoding));
            }
            case "SHA-512": {
                return DigestUtils.sha512Hex((byte[])content.getBytes(encoding));
            }
            case "MD2": {
                return DigestUtils.md2Hex((byte[])content.getBytes(encoding));
            }
            case "MD5": {
                return DigestUtils.md5Hex((byte[])content.getBytes(encoding));
            }
            case "AES-256": {
                try {
                    return ComputeHash.encryptAes(content.getBytes(encoding), ComputeHash.getIvKeyZeroBased(encoding), key.getBytes(encoding));
                }
                catch (NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                    throw new IllegalArgumentException("Error occurred during encryption '" + algorithm + "'. \n" + ComputeHash.getExceptionMessage());
                }
                catch (InvalidKeyException e) {
                    throw new IllegalArgumentException("Error occurred during encryption '" + algorithm + "'. Key should contain 32 bytes. \n" + ComputeHash.getExceptionMessage());
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new IllegalArgumentException("Error occurred during encryption '" + algorithm + "'. Only 8-bit encoding allowed for this algorithm: UTF-8, Windows 1251, etc. \n" + ComputeHash.getExceptionMessage());
                }
            }
            case "CRC-32": {
                return ComputeHash.crc32Hex(content.getBytes(encoding));
            }
            case "RS256": {
                return ComputeHash.encryptJws(content.getBytes(encoding), key.getBytes(encoding), JWSAlgorithm.RS256, algorithm);
            }
            case "RS512": {
                return ComputeHash.encryptJws(content.getBytes(encoding), key.getBytes(encoding), JWSAlgorithm.RS512, algorithm);
            }
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)algorithm, (CharSequence)"HMAC")) {
            return ComputeHash.hmacXxxToHex(algorithm, content.getBytes(encoding), key.getBytes(encoding), encodeToBase64);
        }
        throw new IllegalArgumentException("Wrong algorithm '" + algorithm + "'. " + ComputeHash.getExceptionMessage());
    }

    private static byte[] getIvKeyZeroBased(String encoding) throws UnsupportedEncodingException {
        String ivKeyZeroBased = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
        return "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes(encoding);
    }

    private static String crc32Hex(byte[] data) {
        CRC32 crc = new CRC32();
        crc.update(data);
        return Long.toHexString(crc.getValue());
    }

    private static String hmacXxxToHex(String algorithm, byte[] data, byte[] key, Boolean encodeToBase64) throws IllegalArgumentException {
        try {
            String algorithmName = "Hmac" + algorithm.substring(4).replace("-", "").toUpperCase();
            Mac xxxHmac = Mac.getInstance(algorithmName);
            SecretKeySpec secretKey = new SecretKeySpec(key, algorithmName);
            xxxHmac.init(secretKey);
            byte[] digest = xxxHmac.doFinal(data);
            return encodeToBase64 != false ? Base64.getEncoder().encodeToString(digest) : Hex.encodeHexString((byte[])digest);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException("Exception while computing '" + algorithm + "'. " + ComputeHash.getExceptionMessage(), ex);
        }
    }

    private static String encryptAes(byte[] toBeEncrypt, byte[] ivkey, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        IvParameterSpec ivParameterSpec = new IvParameterSpec(ivkey);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        return Base64.getEncoder().encodeToString(cipher.doFinal(toBeEncrypt));
    }

    private static String encryptJws(byte[] toBeEncrypt, byte[] key, JWSAlgorithm jwsAlgorithm, String algorithmName) {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(key));
            KeyFactory kf = KeyFactory.getInstance("RSA");
            RSAPrivateKey privateKey = (RSAPrivateKey)kf.generatePrivate(keySpec);
            RSASSASigner signer = new RSASSASigner((PrivateKey)privateKey, true);
            Payload contentPayload = new Payload(toBeEncrypt);
            JWSObject jwsObject = new JWSObject(new JWSHeader(jwsAlgorithm), contentPayload);
            jwsObject.sign((JWSSigner)signer);
            return jwsObject.serialize();
        }
        catch (JOSEException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalArgumentException("Exception while computing " + algorithmName + " algorithm: " + ComputeHash.getExceptionMessage(), e);
        }
    }

    private static String getExceptionMessage() {
        return "Directive '#hashsum': 1st argument is $algorithm \n('SHA-1', 'SHA-256', 'SHA-384', 'SHA-512', 'MD2', 'MD5', 'CRC-32', 'HMAC-xxx', 'AES-256', 'RS256', 'RS512'), \n2nd argument is $content, \n3rd argument is $encoding (this argument can be empty - UTF-8 by default), \n4th argument is $key (key is needed for 'HMAC-xxx', 'AES-256', 'RS256' and 'RS512'),\n5th argument = \"true\" (encode digest via Base64) or \"false\" (encode digest via Hex.encodeHexString) (default is false) (only for 'HMAC-xxx' currently),\n where 'HMAC-xxx' are: HMAC-SHA256, HMAC-SHA1, HMAC-SHA384 and so on.";
    }
}

