/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.template.velocity.directives;

import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.Payload;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;

public class DecodeHashsum
extends Directive {
    public String getName() {
        return "decode_hashsum";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        int paramsCount = node.jjtGetNumChildren();
        if (paramsCount != 2) {
            throw new IllegalArgumentException("#" + this.getName() + ": Incorrect number of parameters! " + DecodeHashsum.getExceptionMessage());
        }
        String algorithm = this.getString(node.jjtGetChild(0), internalContextAdapter);
        String content = this.getString(node.jjtGetChild(1), internalContextAdapter);
        if (algorithm == null || content == null) {
            throw new IllegalArgumentException("#" + this.getName() + ": Parameters must be non-null! " + DecodeHashsum.getExceptionMessage());
        }
        writer.append(this.decode_computeHash(algorithm.toUpperCase(), content));
        return true;
    }

    private String getString(Node node, InternalContextAdapter internalContextAdapter) {
        return node == null ? null : String.valueOf(node.value(internalContextAdapter));
    }

    private String decode_computeHash(String algorithm, String content) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        switch (algorithm) {
            case "RS256": 
            case "RS512": {
                return DecodeHashsum.decodeEncryptJws(content, algorithm);
            }
        }
        throw new IllegalArgumentException("Unknown algorithm '" + algorithm + "'. " + DecodeHashsum.getExceptionMessage());
    }

    private static String decodeEncryptJws(String toBeEncrypt, String algorithmName) {
        try {
            JWSObject jwsObject = JWSObject.parse((String)toBeEncrypt);
            Payload payload = jwsObject.getPayload();
            return payload.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception while computing " + algorithmName + " algorithm: " + DecodeHashsum.getExceptionMessage(), e);
        }
    }

    private static String getExceptionMessage() {
        return "Directive '#decode_hashsum': 1st argument is $algorithm ('RS256', 'RS512'), 2nd argument is $content.";
    }
}

