/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.converter;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.core.util.exception.TransportException;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;

public class PropertiesConverter {
    @SafeVarargs
    public static ConnectionProperties convert(String typeName, Map<String, String> ... configurations) throws TransportException {
        return PropertiesConverter.convert(null, typeName, Arrays.stream(configurations).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static ConnectionProperties convert(InstanceContext instanceContext, String typeName, Map<String, String> ... configurations) throws TransportException {
        return PropertiesConverter.convert(instanceContext, typeName, Arrays.stream(configurations).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private static ConnectionProperties convert(InstanceContext instanceContext, String typeName, Collection<? extends Map<String, String>> configurations) throws TransportException {
        HashMap merged = Maps.newHashMap();
        for (Map<String, String> map : configurations) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String value = entry.getValue();
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                merged.put(entry.getKey(), value);
            }
        }
        return PropertiesConverter.convert(instanceContext, typeName, (Map<String, String>)merged);
    }

    public static ConnectionProperties convert(InstanceContext instanceContext, String typeName, Map<String, String> configuration) throws TransportException {
        Map<String, PropertyDescriptor> properties = TransportRegistryManager.getInstance().getProperties(typeName);
        if (properties == null) {
            throw new IllegalStateException(String.format("Transport %s did not export any properties. Configuration is %s", typeName, configuration));
        }
        ConnectionProperties toReturn = new ConnectionProperties();
        for (Map.Entry<String, PropertyDescriptor> entry : properties.entrySet()) {
            PropertyDescriptor descriptor;
            Object convert;
            String stringValue = configuration.get(entry.getKey());
            if (Strings.isNullOrEmpty((String)stringValue) || (convert = descriptor.convert((descriptor = entry.getValue()).isMap() ? PropertiesConverter.preProcess(stringValue, descriptor, instanceContext) : stringValue)) == null) continue;
            toReturn.put(entry.getKey(), convert);
        }
        return toReturn;
    }

    private static String preProcess(String stringValue, PropertyDescriptor descriptor, InstanceContext instanceContext) {
        if (descriptor.isMap() && (stringValue.startsWith("$") || stringValue.startsWith("#"))) {
            return TemplateEngineFactory.get().process((Storable)null, stringValue, instanceContext == null ? new JsonContext() : instanceContext);
        }
        return stringValue;
    }
}

