/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.db;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Named;
import org.qubership.automation.itf.core.util.db.TxCallable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class TxExecutor {
    private static final java.util.function.Supplier<PlatformTransactionManager> DEFAULT = () -> new PlatformTransactionManager(){

        public TransactionStatus getTransaction(TransactionDefinition transactionDefinition) throws TransactionException {
            return null;
        }

        public void commit(TransactionStatus transactionStatus) throws TransactionException {
        }

        public void rollback(TransactionStatus transactionStatus) throws TransactionException {
        }
    };
    private static final TransactionDefinition DEFAULT_DEFINITION = new DefaultTransactionDefinition(0);
    private static final TransactionDefinition READ_ONLY_DEFINITION;
    private static final TransactionDefinition NESTED_WRITABLE;
    private static final TransactionDefinition NESTED_READ_ONLY_DEFINITION;
    private static volatile PlatformTransactionManager INSTANCE;

    @Inject
    public TxExecutor(@Named(value="transactionManager") PlatformTransactionManager manager) {
        TxExecutor.init(manager);
    }

    public static PlatformTransactionManager get() {
        TxExecutor.init(DEFAULT);
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(java.util.function.Supplier<PlatformTransactionManager> instance) {
        if (INSTANCE != null) return;
        Class<TxExecutor> clazz = TxExecutor.class;
        synchronized (TxExecutor.class) {
            if (INSTANCE != null) return;
            INSTANCE = instance.get();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void init(PlatformTransactionManager instance) {
        TxExecutor.init(() -> ((Supplier)Suppliers.ofInstance((Object)instance)).get());
    }

    public static TransactionDefinition defaultWritableTransaction() {
        return DEFAULT_DEFINITION;
    }

    public static TransactionDefinition readOnlyTransaction() {
        return READ_ONLY_DEFINITION;
    }

    public static TransactionDefinition nestedReadOnlyTransaction() {
        return NESTED_READ_ONLY_DEFINITION;
    }

    public static TransactionDefinition nestedWritableTransaction() {
        return NESTED_WRITABLE;
    }

    public static <T> T execute(Callable<T> callable, TransactionDefinition def) throws Exception {
        PlatformTransactionManager instance = TxExecutor.get();
        TransactionStatus status = instance.getTransaction(def);
        try {
            T result = callable.call();
            instance.commit(status);
            return result;
        }
        catch (Exception ex) {
            try {
                instance.rollback(status);
            }
            catch (UnexpectedRollbackException unexpectedRollbackException) {
            }
            catch (Exception ex2) {
                throw new Exception("Exception while rolling back: " + ex2.getMessage() + "; initial exception is: ", ex);
            }
            throw ex;
        }
    }

    public static <T> T execute(Callable<T> callable) throws Exception {
        return TxExecutor.execute(callable, TxExecutor.defaultWritableTransaction());
    }

    public static void executeVoid(TxCallable callable, TransactionDefinition def) {
        PlatformTransactionManager instance = TxExecutor.get();
        TransactionStatus status = instance.getTransaction(def);
        try {
            callable.execute();
        }
        catch (Exception ex) {
            try {
                instance.rollback(status);
            }
            catch (Exception ex2) {
                ex2.addSuppressed(ex);
                throw ex2;
            }
            throw ex;
        }
    }

    public static void commit() {
        INSTANCE.commit(TransactionAspectSupport.currentTransactionStatus());
    }

    public static <T> T executeUnchecked(Callable<T> callable, TransactionDefinition def) {
        try {
            return TxExecutor.execute(callable, def);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            return null;
        }
    }

    public static void executeUnchecked(TxCallable callable, TransactionDefinition definition) {
        try {
            TxExecutor.executeVoid(callable, definition);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
        }
    }

    public static <T> T executeUnchecked(Callable<T> callable) {
        return TxExecutor.executeUnchecked(callable, TxExecutor.defaultWritableTransaction());
    }

    static {
        DefaultTransactionDefinition readonly = new DefaultTransactionDefinition(0);
        readonly.setReadOnly(true);
        READ_ONLY_DEFINITION = readonly;
        NESTED_WRITABLE = new DefaultTransactionDefinition(3);
        DefaultTransactionDefinition nestedReadonly = new DefaultTransactionDefinition(3);
        readonly.setReadOnly(true);
        NESTED_READ_ONLY_DEFINITION = nestedReadonly;
    }
}

