/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.ei.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;

abstract class AbstractSerializer<T extends Storable>
extends JsonSerializer<T> {
    AbstractSerializer() {
    }

    public void serializeWithType(T value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject(value, gen);
        this.serialize(value, gen, provider);
        typeSer.writeTypeSuffixForObject(value, gen);
    }

    Folder getHierachy(Storable folderParent) {
        if (folderParent != null) {
            Folder simpleFolder = new Folder();
            simpleFolder.setID(folderParent.getID());
            simpleFolder.setName(folderParent.getName());
            simpleFolder.setDescription(folderParent.getDescription());
            simpleFolder.setVersion(folderParent.getVersion());
            simpleFolder.setNaturalId(folderParent.getNaturalId());
            simpleFolder.setProject(((Folder)folderParent).getProject());
            simpleFolder.setParent(this.getHierachy(folderParent.getParent()));
            return simpleFolder;
        }
        return null;
    }
}

