/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.hazelcast.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"hazelcast.cache.enabled"})
@EnableCaching
@Configuration
public class HazelcastClientConfig {
    @Value(value="${hazelcast.cluster-name}")
    private String clusterName;
    @Value(value="${hazelcast.address}")
    private String hazelcastAddress;
    @Value(value="${hazelcast.client.name}")
    private String hazelcastClientName;

    @Bean(name={"clientConfig"})
    public ClientConfig clientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setClusterName(this.clusterName);
        clientConfig.setInstanceName(this.hazelcastClientName);
        clientConfig.getNetworkConfig().addAddress(new String[]{this.hazelcastAddress});
        clientConfig.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.ASYNC);
        return clientConfig;
    }
}

