/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.manager;

import org.qubership.automation.itf.core.hibernate.ManagerFactory;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.util.manager.CoreObjectManagerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CoreObjectManager {
    private static CoreObjectManagerService staticCoreObjectManagerService;

    @Autowired
    private CoreObjectManager(CoreObjectManagerService coreObjectManagerService) {
        staticCoreObjectManagerService = coreObjectManagerService;
    }

    public static CoreObjectManagerService getInstance() {
        return staticCoreObjectManagerService;
    }

    public ManagerFactory getManagerFactory() {
        return staticCoreObjectManagerService.getManagerFactory();
    }

    public static <U extends Storable> ObjectManager<U> managerFor(Class<U> clazz) {
        return CoreObjectManager.getInstance().getManager(clazz);
    }

    public <U extends Storable> ObjectManager<U> getManager(Class<U> clazz) {
        return staticCoreObjectManagerService.getManager(clazz);
    }

    public <U extends Storable, T extends ObjectManager<U>> T getSpecialManager(Class<U> clazz, Class<T> toCast) {
        ObjectManager<U> manager = staticCoreObjectManagerService.getManager(clazz);
        if (toCast.isAssignableFrom(manager.getClass())) {
            return (T)manager;
        }
        throw new IllegalArgumentException(String.format("Object manager %s is not of type %s", manager, toCast.getName()));
    }
}

