/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.services.projectsettings;

import com.hazelcast.map.IMap;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.services.projectsettings.IProjectSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProjectSettingsService
implements IProjectSettingsService {
    private static final Logger log = LoggerFactory.getLogger(AbstractProjectSettingsService.class);

    @Override
    public String get(Object projectId, String shortName, String defaultValue) {
        String value = this.get(IdConverter.toBigInt(projectId), shortName, this.getProjectSettingsCache());
        return StringUtils.isNotEmpty((CharSequence)value) ? value.trim() : defaultValue;
    }

    protected String get(BigInteger projectId, String shortName, IMap<String, Map<String, String>> projectSettingsCache) {
        try {
            Map<String, String> projectSettings = this.getProjectSettings(projectSettingsCache, projectId.toString());
            if (Objects.nonNull(projectSettings)) {
                return projectSettings.get(shortName);
            }
            log.warn("Something went wrong with Hazelcast project settings cache - there is no project settings in cache for project {}", (Object)projectId);
            return null;
        }
        catch (Exception e) {
            log.warn("Error while getting project setting '{}' for project: {}", (Object)shortName, (Object)projectId);
            return null;
        }
    }

    @Override
    public Integer getInt(Object projectId, String shortName, int defaultValue) {
        IMap<String, Map<String, String>> projectSettingsCache = this.getProjectSettingsCache();
        String value = this.get(IdConverter.toBigInt(projectId), shortName, projectSettingsCache);
        return StringUtils.isNotEmpty((CharSequence)value) ? Integer.parseInt(value) : defaultValue;
    }

    @Override
    public Map<String, String> getByPrefix(Object projectId, String prefix, boolean truncPrefix) {
        Map<String, String> projectSettings = this.getAll(IdConverter.toBigInt(projectId));
        if (projectSettings.isEmpty()) {
            return projectSettings;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> property : projectSettings.entrySet()) {
            String key = property.getKey();
            if (!StringUtils.startsWith((CharSequence)key, (CharSequence)prefix)) continue;
            result.put(truncPrefix ? key.substring(prefix.length() + 1) : key, property.getValue());
        }
        return result;
    }

    @Override
    public Map<String, String> getAll(Object projectId) {
        IMap<String, Map<String, String>> projectsSettingsCache = this.getProjectSettingsCache();
        Map<String, String> projectSettings = this.getProjectSettings(projectsSettingsCache, projectId.toString());
        if (Objects.nonNull(projectSettings)) {
            return projectSettings;
        }
        log.warn("Can't get all project settings from cache for project '{}' ", projectId);
        return Collections.emptyMap();
    }

    protected abstract IMap<String, Map<String, String>> getProjectSettingsCache();

    protected Map<String, String> getProjectSettings(IMap<String, Map<String, String>> projectSettingsCache, String projectId) {
        try {
            return (Map)projectSettingsCache.get((Object)projectId);
        }
        catch (Exception e) {
            log.error("Can't get ProjectSettingsMap from Hazelcast for project {}", (Object)projectId, (Object)e);
            return null;
        }
    }
}

