/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.storage;

import org.qubership.automation.itf.core.util.storage.DelegateImpl;
import org.qubership.automation.itf.core.util.storage.StoreInformationDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreDelegateFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreDelegateFactory.class);
    private static StoreDelegateFactory ourInstance = new StoreDelegateFactory();
    private final Class<? extends StoreInformationDelegate> delegateClass;

    public static StoreDelegateFactory getInstance() {
        return ourInstance;
    }

    private StoreDelegateFactory() {
        String delegateClassName = DelegateImpl.class.getName();
        Class<StoreInformationDelegate> tmp = null;
        try {
            tmp = Class.forName(delegateClassName).asSubclass(StoreInformationDelegate.class);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Error initializing factory", (Throwable)e);
        }
        this.delegateClass = tmp;
    }

    public StoreInformationDelegate newDelegate() {
        try {
            return this.delegateClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.error("Error instantiating delegate", (Throwable)e);
            return null;
        }
    }
}

