/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.transport.base;

import com.fasterxml.jackson.annotation.JsonManagedReference;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.annotation.View;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.descriptor.Extractor;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.transport.access.AccessTransport;
import org.qubership.automation.itf.core.util.transport.base.Transport;

public abstract class AbstractBaseTransportImpl<T extends Transport>
implements AccessTransport {
    @JsonManagedReference
    protected final T transport;
    private final String typeName;
    private final String userName;
    private final String directive;
    private final String view;
    private final List<PropertyDescriptor> properties;
    private final List<String> mandatoryProperties;

    public AbstractBaseTransportImpl(T transport) {
        this.transport = transport;
        this.typeName = transport.getClass().getName();
        View viewAnn = transport.getClass().getAnnotation(View.class);
        this.directive = viewAnn == null ? null : viewAnn.directive();
        this.view = viewAnn == null ? null : viewAnn.view();
        this.userName = transport.getClass().isAnnotationPresent(UserName.class) ? transport.getClass().getAnnotation(UserName.class).value() : transport.getClass().getSimpleName();
        this.properties = Extractor.extractProperties(transport);
        this.mandatoryProperties = Extractor.extractMandatory(this.properties);
    }

    @Override
    public String getTypeName() throws RemoteException {
        return this.typeName;
    }

    @Override
    public String getUserName() throws RemoteException {
        return this.userName;
    }

    @Override
    public String send(Message message, String sessionId, UUID projectUuid) throws RemoteException {
        try {
            return this.transport.send(message, sessionId, projectUuid);
        }
        catch (Exception e) {
            throw new RemoteException("Error sending data. Error Message: " + e.toString(), new Throwable(ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    @Override
    public Message receive(String sessionId) throws RemoteException {
        try {
            return this.transport.receive(sessionId);
        }
        catch (Exception e) {
            throw new RemoteException("Error receiving data. Error Message: " + e.toString(), new Throwable(ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    @Override
    public Message sendReceiveSync(Message messageToSend, BigInteger projectId) throws RemoteException {
        try {
            return this.transport.sendReceiveSync(messageToSend, projectId);
        }
        catch (Exception e) {
            throw new RemoteException("Error sending/receiving data. Error Message: " + e.toString(), new Throwable(ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    @Override
    @Nullable
    public String getDirective() throws RemoteException {
        return this.directive;
    }

    @Override
    @Nullable
    public String getView() {
        return this.view;
    }

    @Override
    public List<PropertyDescriptor> getProperties() throws RemoteException {
        return this.properties;
    }

    @Override
    public Mep getMep() throws RemoteException {
        return this.transport.getMep();
    }

    @Override
    public String getEndpointPrefix() {
        return this.transport.getEndpointPrefix();
    }

    public T unwrap() {
        return this.transport;
    }

    @Override
    public List<String> getMandatoryProperties() throws RemoteException {
        return this.mandatoryProperties;
    }
}

