package org.qubership.atp.datasets.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.datasets.dto.LabelFlatDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * DataSetFlatDto
 */

@JsonTypeName("DataSetFlat")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-17T08:53:08.868Z[Etc/UTC]")
public class DataSetFlatDto {

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("labels")
  @Valid
  private List<LabelFlatDto> labels = null;

  @JsonProperty("name")
  private String name;

  public DataSetFlatDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", required = false)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public DataSetFlatDto labels(List<LabelFlatDto> labels) {
    this.labels = labels;
    return this;
  }

  public DataSetFlatDto addLabelsItem(LabelFlatDto labelsItem) {
    if (this.labels == null) {
      this.labels = new ArrayList<>();
    }
    this.labels.add(labelsItem);
    return this;
  }

  /**
   * Get labels
   * @return labels
  */
  @Valid 
  @Schema(name = "labels", required = false)
  public List<LabelFlatDto> getLabels() {
    return labels;
  }

  public void setLabels(List<LabelFlatDto> labels) {
    this.labels = labels;
  }

  public DataSetFlatDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataSetFlatDto dataSetFlat = (DataSetFlatDto) o;
    return Objects.equals(this.id, dataSetFlat.id) &&
        Objects.equals(this.labels, dataSetFlat.labels) &&
        Objects.equals(this.name, dataSetFlat.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, labels, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataSetFlatDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

