package org.qubership.atp.datasets.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.datasets.dto.DataSetDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * DataSetsAndAttributesFilterPairDto
 */

@JsonTypeName("DataSetsAndAttributesFilterPair")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-17T08:53:08.868Z[Etc/UTC]")
public class DataSetsAndAttributesFilterPairDto {

  @JsonProperty("attributes")
  @Valid
  private List<UUID> attributes = null;

  @JsonProperty("datasets")
  @Valid
  private List<DataSetDto> datasets = null;

  public DataSetsAndAttributesFilterPairDto attributes(List<UUID> attributes) {
    this.attributes = attributes;
    return this;
  }

  public DataSetsAndAttributesFilterPairDto addAttributesItem(UUID attributesItem) {
    if (this.attributes == null) {
      this.attributes = new ArrayList<>();
    }
    this.attributes.add(attributesItem);
    return this;
  }

  /**
   * Get attributes
   * @return attributes
  */
  @Valid 
  @Schema(name = "attributes", required = false)
  public List<UUID> getAttributes() {
    return attributes;
  }

  public void setAttributes(List<UUID> attributes) {
    this.attributes = attributes;
  }

  public DataSetsAndAttributesFilterPairDto datasets(List<DataSetDto> datasets) {
    this.datasets = datasets;
    return this;
  }

  public DataSetsAndAttributesFilterPairDto addDatasetsItem(DataSetDto datasetsItem) {
    if (this.datasets == null) {
      this.datasets = new ArrayList<>();
    }
    this.datasets.add(datasetsItem);
    return this;
  }

  /**
   * Get datasets
   * @return datasets
  */
  @Valid 
  @Schema(name = "datasets", required = false)
  public List<DataSetDto> getDatasets() {
    return datasets;
  }

  public void setDatasets(List<DataSetDto> datasets) {
    this.datasets = datasets;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataSetsAndAttributesFilterPairDto dataSetsAndAttributesFilterPair = (DataSetsAndAttributesFilterPairDto) o;
    return Objects.equals(this.attributes, dataSetsAndAttributesFilterPair.attributes) &&
        Objects.equals(this.datasets, dataSetsAndAttributesFilterPair.datasets);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributes, datasets);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataSetsAndAttributesFilterPairDto {\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    datasets: ").append(toIndentedString(datasets)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

