/*
 *  Copyright 2024-2025 NetCracker Technology Corporation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.qubership.automation.itf.core.model.communication.message;

import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Setter
@Getter
@NoArgsConstructor
public class CommonTriggerExecutionMessage extends TriggerExecutionMessage {
    private static final long serialVersionUID = 20240812L;

    private String typeName;
    private StorableDescriptor triggerConfigurationDescriptor;

    /**
     * TODO: Add JavaDoc.
     */
    public CommonTriggerExecutionMessage(String typeName, Message message,
                                         StorableDescriptor triggerConfigurationDescriptor,
                                         String sessionId, String brokerMessageSelectorValue) {
        super(message, sessionId, brokerMessageSelectorValue);
        this.typeName = typeName;
        this.triggerConfigurationDescriptor = triggerConfigurationDescriptor;
    }
}
