/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.datasets.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.datasets.dto.FileDataDto;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="AttachmentController", description="Attachment Controller")
public interface AttachmentControllerApi {
    @Operation(operationId="deleteByAttributeIdAndDatasetId", summary="deleteByAttributeIdAndDatasetId", tags={"attachment-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/attachment/attributeId/{attributeId}/dataset/{datasetId}"})
    public ResponseEntity<Void> deleteByAttributeIdAndDatasetId(@Parameter(name="attributeId", description="attributeId", required=true) @PathVariable(value="attributeId") UUID var1, @Parameter(name="datasetId", description="datasetId", required=true) @PathVariable(value="datasetId") UUID var2);

    @Operation(operationId="deleteByParameterId", summary="deleteByParameterId", tags={"attachment-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/attachment/{parameterUuid}"})
    public ResponseEntity<Void> deleteByParameterId(@Parameter(name="parameterUuid", description="parameterUuid", required=true) @PathVariable(value="parameterUuid") UUID var1);

    @Operation(operationId="getAttachmentByAttributeIdAndDatasetId", summary="getAttachmentByAttributeIdAndDatasetId", tags={"attachment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/octet-stream", schema=@Schema(implementation=Resource.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/attachment/attributeId/{attributeId}/dataset/{datasetId}"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> getAttachmentByAttributeIdAndDatasetId(@Parameter(name="attributeId", description="attributeId", required=true) @PathVariable(value="attributeId") UUID var1, @Parameter(name="datasetId", description="datasetId", required=true) @PathVariable(value="datasetId") UUID var2);

    @Operation(operationId="getAttachmentByParameterId", summary="getAttachmentByParameterId", tags={"attachment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/octet-stream", schema=@Schema(implementation=Resource.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/attachment/{parameterUuid}"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> getAttachmentByParameterId(@Parameter(name="parameterUuid", description="parameterUuid", required=true) @PathVariable(value="parameterUuid") UUID var1);

    @Operation(operationId="uploadByAttributeIdAndDatasetId", summary="uploadByAttributeIdAndDatasetId", tags={"attachment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=FileDataDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="226", description="IM Used"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/attachment/attributeId/{attributeId}/dataset/{datasetId}"}, produces={"application/json"})
    public ResponseEntity<FileDataDto> uploadByAttributeIdAndDatasetId(@Parameter(name="attributeId", description="attributeId", required=true) @PathVariable(value="attributeId") UUID var1, @Parameter(name="datasetId", description="datasetId", required=true) @PathVariable(value="datasetId") UUID var2, @NotNull @Parameter(name="type", description="type", required=true) @Valid @RequestParam(value="type", required=true) String var3, @NotNull @Parameter(name="fileName", description="fileName", required=true) @Valid @RequestParam(value="fileName", required=true) String var4, @NotNull @Parameter(name="file", description="file", required=true) @Valid @RequestParam(value="file", required=true) Resource var5, @Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var6, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var7);

    @Operation(operationId="uploadByParameterId", summary="uploadByParameterId", tags={"attachment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=FileDataDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/attachment/{parameterUuid}"}, produces={"application/json"})
    public ResponseEntity<FileDataDto> uploadByParameterId(@Parameter(name="parameterUuid", description="parameterUuid", required=true) @PathVariable(value="parameterUuid") UUID var1, @NotNull @Parameter(name="type", description="type", required=true) @Valid @RequestParam(value="type", required=true) String var2, @NotNull @Parameter(name="fileName", description="fileName", required=true) @Valid @RequestParam(value="fileName", required=true) String var3, @NotNull @Parameter(name="file", description="file", required=true) @Valid @RequestParam(value="file", required=true) Resource var4);
}

