/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.datasets.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.datasets.dto.AffectedDataSetListDto;
import org.qubership.atp.datasets.dto.CopyDataSetListsRequestDto;
import org.qubership.atp.datasets.dto.CopyDataSetListsResponseDto;
import org.qubership.atp.datasets.dto.CyclesCheckResultDto;
import org.qubership.atp.datasets.dto.DataSetDto;
import org.qubership.atp.datasets.dto.DataSetListCreatedModifiedViewDto;
import org.qubership.atp.datasets.dto.DataSetListDependencyNodeDto;
import org.qubership.atp.datasets.dto.DataSetsAndAttributesFilterPairDto;
import org.qubership.atp.datasets.dto.DatasetListImportResponseDto;
import org.qubership.atp.datasets.dto.DatasetResponseDto;
import org.qubership.atp.datasets.dto.LabelDto;
import org.qubership.atp.datasets.dto.PairDto;
import org.qubership.atp.datasets.dto.TableResponseDto;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="DataSetListController", description="Data Set List Controller")
public interface DataSetListControllerApi {
    @Operation(operationId="addLabel", summary="addLabel", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LabelDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/dsl/{dataSetListId}/label"}, produces={"application/json"})
    public ResponseEntity<LabelDto> addLabel(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1, @NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var2, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var3);

    @Operation(operationId="copy", summary="Copy DSL with name provided.", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CopyDataSetListsResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/dsl/copy"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<CopyDataSetListsResponseDto>> copy(@Parameter(name="CopyDataSetListsRequestDto", description="") @Valid @RequestBody(required=false) CopyDataSetListsRequestDto var1);

    @Operation(operationId="copyBulk", summary="Copy DSLs and DSs. Uses for cloning of test plan on Catalog", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=PairDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/dsl/ds/clone/bulk"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Map<String, PairDto>> copyBulk(@NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var1, @Parameter(name="request_body", description="") @Valid @RequestBody(required=false) Map<String, Set<UUID>> var2);

    @Operation(operationId="copyByVaIdDataSetListId", summary="Copy DSL with name provided.", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/dsl/va/{vaId}/dsl/{dataSetListId}/copy"}, produces={"application/json"})
    public ResponseEntity<UUID> copyByVaIdDataSetListId(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1, @Parameter(name="vaId", description="vaId", required=true) @PathVariable(value="vaId") UUID var2, @NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var3, @Parameter(name="type", description="type") @Valid @RequestParam(value="type", required=false) Boolean var4, @Parameter(name="testPlan", description="testPlan") @Valid @RequestParam(value="testPlan", required=false) UUID var5);

    @Operation(operationId="create", summary="Creates new DSL with name provided.", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/dsl/va/{vaId}"}, produces={"application/json"})
    public ResponseEntity<UUID> create(@Parameter(name="vaId", description="vaId", required=true) @PathVariable(value="vaId") UUID var1, @NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var2, @Parameter(name="testPlan", description="testPlan") @Valid @RequestParam(value="testPlan", required=false) UUID var3);

    @Operation(operationId="delete", summary="Deletes selected DSL.", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/dsl/{dataSetListId}"})
    public ResponseEntity<Void> delete(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1);

    @Operation(operationId="deleteLabel", summary="deleteLabel", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/dsl/{dataSetListId}/label/{labelId}"}, produces={"application/json"})
    public ResponseEntity<Boolean> deleteLabel(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1, @Parameter(name="labelId", description="labelId", required=true) @PathVariable(value="labelId") UUID var2, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var3);

    @Operation(operationId="existsById", summary="Check if dsl exists.", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl/{dataSetListId}/exists"})
    public ResponseEntity<Void> existsById(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1);

    @Operation(operationId="exportDataSetList", summary="Export dsl to file.", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", schema=@Schema(implementation=Resource.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/dsl/{dataSetListId}/export/excel"}, produces={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public ResponseEntity<Resource> exportDataSetList(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1);

    @Operation(operationId="getAffectedAttributes", summary="Get affected attribute by deleting dsl( data set storage).", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TableResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl/{dataSetListId}/getAffected"}, produces={"application/json"})
    public ResponseEntity<List<TableResponseDto>> getAffectedAttributes(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1);

    @Operation(operationId="getAffectedAttributesCount", summary="Get affected attribute count by dsl.", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=BigDecimal.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl/{dataSetListId}/getAffectedCount"}, produces={"application/json"})
    public ResponseEntity<BigDecimal> getAffectedAttributesCount(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1);

    @Operation(operationId="getAffectedDataSetLists", summary="Get affected dsl by deleting dsl( data set storage).", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="206", description="Partial Content", content={@Content(mediaType="application/json", schema=@Schema(implementation=AffectedDataSetListDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl/{dataSetListId}/getAffectedDSL"}, produces={"application/json"})
    public ResponseEntity<Void> getAffectedDataSetLists(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1, @Parameter(name="limit", description="limit") @Valid @RequestParam(value="limit", required=false) Integer var2, @Parameter(name="offset", description="offset") @Valid @RequestParam(value="offset", required=false) Integer var3);

    @Operation(operationId="getCyclesCheck", summary="Get affected attribute by deleting dsl( data set storage).", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CyclesCheckResultDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl/cyclesCheck"}, produces={"application/json"})
    public ResponseEntity<CyclesCheckResultDto> getCyclesCheck();

    @Operation(operationId="getDataSetInfoByDataSetListIdAndId", summary="Returns information about the selected DS under DSL.", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl/{dataSetListId}/ds/{ds}"}, produces={"application/json"})
    public ResponseEntity<Object> getDataSetInfoByDataSetListIdAndId(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1, @Parameter(name="ds", description="ds", required=true) @PathVariable(value="ds") UUID var2);

    @Operation(operationId="getDataSetListFullInfo", summary="Returns datasets full information of the selected DSL.", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataSetDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl/{dataSetListId}/full"}, produces={"application/json"})
    public ResponseEntity<List<DataSetDto>> getDataSetListFullInfo(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1);

    @Operation(operationId="getDataSetListInfo", summary="Returns information about the selected DSL.", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl/{dataSetListId}"}, produces={"application/json"})
    public ResponseEntity<Object> getDataSetListInfo(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1, @Parameter(name="filterDs", description="filterDs") @Valid @RequestParam(value="filterDs", required=false) String var2, @Parameter(name="filterAttr", description="filterAttr") @Valid @RequestParam(value="filterAttr", required=false) String var3, @Parameter(name="flat", description="flat") @Valid @RequestParam(value="flat", required=false) String var4, @Parameter(name="new", description="new") @Valid @RequestParam(value="new", required=false) String var5, @Parameter(name="evaluate", description="evaluate") @Valid @RequestParam(value="evaluate", required=false) String var6);

    @Operation(operationId="getDataSetListInfoById", summary="Returns information about the selected DSL.", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/dsl/{dataSetListId}/filters"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Object> getDataSetListInfoById(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1, @Parameter(name="evaluate", description="evaluate") @Valid @RequestParam(value="evaluate", required=false) String var2, @Parameter(name="startIndex", description="startIndex") @Valid @RequestParam(value="startIndex", required=false) Integer var3, @Parameter(name="endIndex", description="endIndex") @Valid @RequestParam(value="endIndex", required=false) Integer var4, @Parameter(name="sort", description="sort") @Valid @RequestParam(value="sort", required=false) String var5, @Parameter(name="DataSetsAndAttributesFilterPairDto", description="") @Valid @RequestBody(required=false) DataSetsAndAttributesFilterPairDto var6);

    @Operation(operationId="getDataSetLists", summary="Returns all dataSetLists.", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataSetListCreatedModifiedViewDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl"}, produces={"application/json"})
    public ResponseEntity<List<DataSetListCreatedModifiedViewDto>> getDataSetLists();

    @Operation(operationId="getDataSetListsByVaId", summary="Returns all dataSetLists for selected visibility area.", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataSetListCreatedModifiedViewDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl/va/{vaId}"}, produces={"application/json"})
    public ResponseEntity<List<DataSetListCreatedModifiedViewDto>> getDataSetListsByVaId(@Parameter(name="vaId", description="vaId", required=true) @PathVariable(value="vaId") UUID var1, @Parameter(name="label", description="label") @Valid @RequestParam(value="label", required=false) String var2);

    @Operation(operationId="getDataSets", summary="Returns datasets id/name information of the selected DSL.", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataSetDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl/{dataSetListId}/ds"}, produces={"application/json"})
    public ResponseEntity<List<DataSetDto>> getDataSets(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1, @Parameter(name="skipEvaluate", description="skipEvaluate") @Valid @RequestParam(value="skipEvaluate", required=false) String var2, @Parameter(name="label", description="label") @Valid @RequestParam(value="label", required=false) String var3);

    @Operation(operationId="getDataSetsWithNameAndDataSetList", summary="getDataSetsWithNameAndDataSetList", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatasetResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/dsl/ds/all"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<DatasetResponseDto>> getDataSetsWithNameAndDataSetList(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var1);

    @Operation(operationId="getDependencies", summary="Get dataset lists dependencies trees", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataSetListDependencyNodeDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/dsl/dependencies"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<DataSetListDependencyNodeDto>> getDependencies(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var1);

    @Operation(operationId="getDependenciesRecursive", summary="Get dataset lists dependencies trees", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataSetListDependencyNodeDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/dsl/dependenciesRecursive"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<DataSetListDependencyNodeDto>> getDependenciesRecursive(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var1);

    @Operation(operationId="getLabels", summary="getLabels", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LabelDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl/{dataSetListId}/label"}, produces={"application/json"})
    public ResponseEntity<List<LabelDto>> getLabels(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1);

    @Operation(operationId="getModifiedWhen", summary="Get dsl modifiedWhen.", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=OffsetDateTime.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl/{dataSetListId}/modifiedWhen"}, produces={"application/json"})
    public ResponseEntity<OffsetDateTime> getModifiedWhen(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1);

    @Operation(operationId="importDataSetList", summary="Import dsl from excel file.", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatasetListImportResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/dsl/{dataSetListId}/import/excel"}, produces={"application/json"})
    public ResponseEntity<DatasetListImportResponseDto> importDataSetList(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1, @NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var2, @Parameter(name="versioning", description="versioning") @Valid @RequestParam(value="versioning", required=false) Boolean var3);

    @Operation(operationId="rename", summary="Renames selected DSL.", tags={"data-set-list-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/dsl/{dataSetListId}"}, produces={"application/json"})
    public ResponseEntity<Boolean> rename(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1, @Parameter(name="name", description="name") @Valid @RequestParam(value="name", required=false) String var2, @Parameter(name="testPlan", description="testPlan") @Valid @RequestParam(value="testPlan", required=false) UUID var3, @Parameter(name="clearTestPlan", description="clearTestPlan") @Valid @RequestParam(value="clearTestPlan", required=false) String var4, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var5);
}

