/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.datasets.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.datasets.dto.AttributeTypeDto;
import org.qubership.atp.datasets.dto.DataSetListDto;
import org.qubership.atp.datasets.dto.ListValueDto;
import org.qubership.atp.datasets.dto.ParameterDto;

@JsonTypeName(value="Attribute")
public class AttributeDto {
    @JsonProperty(value="dataSetList")
    private DataSetListDto dataSetList;
    @JsonProperty(value="dataSetListReference")
    private DataSetListDto dataSetListReference;
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="listValues")
    @Valid
    private List<ListValueDto> listValues = null;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="parameters")
    @Valid
    private List<ParameterDto> parameters = null;
    @JsonProperty(value="type")
    private AttributeTypeDto type;

    public AttributeDto dataSetList(DataSetListDto dataSetList) {
        this.dataSetList = dataSetList;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="dataSetList", required=true)
    public DataSetListDto getDataSetList() {
        return this.dataSetList;
    }

    public void setDataSetList(DataSetListDto dataSetList) {
        this.dataSetList = dataSetList;
    }

    public AttributeDto dataSetListReference(DataSetListDto dataSetListReference) {
        this.dataSetListReference = dataSetListReference;
        return this;
    }

    @Valid
    @Schema(name="dataSetListReference", required=false)
    public DataSetListDto getDataSetListReference() {
        return this.dataSetListReference;
    }

    public void setDataSetListReference(DataSetListDto dataSetListReference) {
        this.dataSetListReference = dataSetListReference;
    }

    public AttributeDto id(UUID id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="id", required=true)
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public AttributeDto listValues(List<ListValueDto> listValues) {
        this.listValues = listValues;
        return this;
    }

    public AttributeDto addListValuesItem(ListValueDto listValuesItem) {
        if (this.listValues == null) {
            this.listValues = new ArrayList<ListValueDto>();
        }
        this.listValues.add(listValuesItem);
        return this;
    }

    @Valid
    @Schema(name="listValues", description="for list type", required=false)
    public List<ListValueDto> getListValues() {
        return this.listValues;
    }

    public void setListValues(List<ListValueDto> listValues) {
        this.listValues = listValues;
    }

    public AttributeDto name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AttributeDto parameters(List<ParameterDto> parameters) {
        this.parameters = parameters;
        return this;
    }

    public AttributeDto addParametersItem(ParameterDto parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParameterDto>();
        }
        this.parameters.add(parametersItem);
        return this;
    }

    @Valid
    @Schema(name="parameters", required=false)
    public List<ParameterDto> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ParameterDto> parameters) {
        this.parameters = parameters;
    }

    public AttributeDto type(AttributeTypeDto type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="type", required=true)
    public AttributeTypeDto getType() {
        return this.type;
    }

    public void setType(AttributeTypeDto type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeDto attribute = (AttributeDto)o;
        return Objects.equals(this.dataSetList, attribute.dataSetList) && Objects.equals(this.dataSetListReference, attribute.dataSetListReference) && Objects.equals(this.id, attribute.id) && Objects.equals(this.listValues, attribute.listValues) && Objects.equals(this.name, attribute.name) && Objects.equals(this.parameters, attribute.parameters) && Objects.equals((Object)this.type, (Object)attribute.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataSetList, this.dataSetListReference, this.id, this.listValues, this.name, this.parameters, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AttributeDto {\n");
        sb.append("    dataSetList: ").append(this.toIndentedString(this.dataSetList)).append("\n");
        sb.append("    dataSetListReference: ").append(this.toIndentedString(this.dataSetListReference)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    listValues: ").append(this.toIndentedString(this.listValues)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

