/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.config;

import java.util.Objects;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.qubership.automation.itf.core.config.CommonHibernateConfiguration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;

@Configuration
@Import(value={CommonHibernateConfiguration.class})
public class ReportHibernateConfiguration {
    @Bean(name={"entityManagerFactory"})
    public FactoryBean<EntityManagerFactory> getCustomLocalContainerEntityManagerFactoryBean(DataSource dataSource, Properties jpaProperties) {
        LocalContainerEntityManagerFactoryBean emf = new LocalContainerEntityManagerFactoryBean();
        emf.setPackagesToScan(new String[]{"org.qubership.automation.itf.core.model.jpa"});
        emf.setDataSource(dataSource);
        emf.setJpaVendorAdapter((JpaVendorAdapter)new HibernateJpaVendorAdapter());
        emf.setMappingResources(new String[]{"mapping/AbstractInstance.hbm.xml", "mapping/JSONContext.hbm.xml", "mapping/Message.hbm.xml", "mapping/MessageParameter.hbm.xml", "mapping/UpgradeHistory.hbm.xml"});
        jpaProperties.setProperty("hibernate.hbm2ddl.auto", "none");
        emf.setJpaProperties(Objects.requireNonNull(jpaProperties));
        return emf;
    }

    @Bean(name={"transactionManager"})
    public JpaTransactionManager getJpaTransactionManager(FactoryBean<EntityManagerFactory> entityManagerFactory) throws Exception {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory((EntityManagerFactory)entityManagerFactory.getObject());
        return transactionManager;
    }
}

