/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AttributeConverter;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.condition.parameter.ConditionParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionParametersConverter
implements AttributeConverter<List<ConditionParameter>, String> {
    private static final Logger log = LoggerFactory.getLogger(ConditionParametersConverter.class);
    ObjectMapper objectMapper = new ObjectMapper();

    public String convertToDatabaseColumn(List<ConditionParameter> attribute) {
        String attributeJson = null;
        try {
            attributeJson = this.objectMapper.writeValueAsString(attribute);
        }
        catch (JsonProcessingException e) {
            log.error("JSON writing error", (Throwable)e);
        }
        return attributeJson;
    }

    public List<ConditionParameter> convertToEntityAttribute(String dbData) {
        List<ConditionParameter> conditionParameters = new ArrayList<ConditionParameter>();
        try {
            if (StringUtils.isNotBlank((CharSequence)dbData)) {
                conditionParameters = (List)this.objectMapper.readValue(dbData, (TypeReference)new TypeReference<List<ConditionParameter>>(){});
            }
        }
        catch (IOException e) {
            log.error("JSON reading error", (Throwable)e);
        }
        return conditionParameters;
    }
}

