/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.executor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.ObjectCreationByTypeManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.IntegrationConfigRepository;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.project.IntegrationConfig;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.util.config.ApplicationConfig;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.registry.EngineIntegrationRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IntegrationConfigObjectManager
extends AbstractObjectManager<IntegrationConfig, IntegrationConfig>
implements ObjectCreationByTypeManager<IntegrationConfig> {
    @Autowired
    public IntegrationConfigObjectManager(IntegrationConfigRepository repository) {
        super(IntegrationConfig.class, repository);
    }

    @Override
    public IntegrationConfig create(Storable parent, String type) {
        IntegrationConfig result = new IntegrationConfig();
        result.setParent(parent);
        result.setName(type);
        result.setTypeName(type);
        this.repository.save(result);
        this.addPropertiesToConfig(result);
        return result;
    }

    @Override
    public IntegrationConfig create(Storable parent, String name, String type, Map parameters) {
        IntegrationConfig integrationConfig = new IntegrationConfig(parent, parameters);
        integrationConfig.setName(name);
        integrationConfig.setTypeName(type);
        return (IntegrationConfig)this.repository.save(integrationConfig);
    }

    private void addPropertiesToConfig(IntegrationConfig config) {
        for (PropertyDescriptor property : EngineIntegrationRegistry.getInstance().getProperties(config.getName())) {
            String propertyValue = ApplicationConfig.env.getProperty(property.getShortName(), "");
            if (!StringUtils.isNotEmpty((CharSequence)propertyValue)) continue;
            config.put(property.getShortName(), propertyValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only IntegrationConfig objects are here")
    public void afterDelete(Storable object) {
        if (object.getParent() instanceof StubProject) {
            Storable storable = object.getParent();
            synchronized (storable) {
                ((StubProject)object.getParent()).getIntegrationConfs().remove((IntegrationConfig)object);
            }
        }
    }
}

