/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.executor;

import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.ByProject;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.LabeledObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.NativeManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByProjectIdManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.OperationTemplateRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.OutboundTransportConfigurationRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.StepRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.TemplateRepository;
import org.qubership.automation.itf.core.model.IdNamePair;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.message.template.OperationTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.SystemTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.template.OutboundTemplateTransportConfiguration;
import org.qubership.automation.itf.core.model.usage.UsageInfo;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.provider.TemplateProvider;

public abstract class TemplateObjectManager<K extends TemplateProvider, T extends Template<K>>
extends AbstractObjectManager<T, T>
implements NativeManager<T>,
LabeledObjectManager<T>,
ByProject<T>,
SearchByProjectIdManager<T> {
    private final TemplateRepository templateRepository;
    private final StepRepository stepRepository;
    private final OutboundTransportConfigurationRepository outboundTransportConfigurationRepository;

    public TemplateObjectManager(Class<T> clazz, TemplateRepository<K, T> templateRepository, StepRepository stepRepository, OutboundTransportConfigurationRepository outboundTransportConfigurationRepository) {
        super(clazz, templateRepository);
        this.templateRepository = templateRepository;
        this.stepRepository = stepRepository;
        this.outboundTransportConfigurationRepository = outboundTransportConfigurationRepository;
    }

    @Override
    public void protectedOnRemove(T object) {
        if (object instanceof SystemTemplate) {
            this.stepRepository.onDeleteSystemTemplate((Template)object);
        } else {
            this.stepRepository.onDeleteOperationTemplate((Template)object);
        }
    }

    @Override
    public Collection<UsageInfo> findUsages(Storable storable) {
        ArrayList all = storable instanceof SystemTemplate ? this.stepRepository.getIntegrationStepsBySystemTemplate((SystemTemplate)storable) : (storable instanceof OperationTemplate ? this.stepRepository.getIntegrationStepsByOperationTemplate((OperationTemplate)storable) : new ArrayList());
        HashSet result = Sets.newHashSet();
        TemplateObjectManager.addToUsages(result, "template", all);
        return result;
    }

    public List<Map<String, Object>> findUsagesOnOutboundDiameterConfiguration(Storable storable) {
        return this.templateRepository.findUsagesOnOutboundDiameterConfiguration((BigInteger)storable.getID(), storable.getProjectId());
    }

    @Override
    public Storable getChildByClass(T parent, Class childrenClass, Object ... param) {
        throw new NotImplementedException("");
    }

    @Override
    public Collection<? extends Storable> getChildrenByClass(T parent, Class childrenClass, Object ... param) {
        if (childrenClass.getName().equals(OutboundTemplateTransportConfiguration.class.getName())) {
            if (param[0] != null) {
                return this.outboundTransportConfigurationRepository.findCfgByTemplateAndType(IdConverter.toBigInt(parent.getID()), String.valueOf(param[0]));
            }
            return this.outboundTransportConfigurationRepository.findAllCfgByTemplate(IdConverter.toBigInt(parent.getID()));
        }
        throw new NotImplementedException("Implemented only for " + OutboundTemplateTransportConfiguration.class.getName() + " class");
    }

    @Override
    public Collection<T> getAllByProject(Object projectId) {
        throw new NotImplementedException("Not implemented for project");
    }

    @Override
    public Collection<T> getByLabel(String label) {
        throw new NotImplementedException("Method getByLabel is not implemented");
    }

    @Override
    public Collection<T> getByLabel(String label, BigInteger projectId) {
        throw new NotImplementedException("Method getByLabel is not implemented");
    }

    @Override
    public Set<String> getAllLabels(BigInteger projectId) {
        return TxExecutor.executeUnchecked(() -> ((TemplateRepository)this.repository).getAllLabels(projectId), TxExecutor.readOnlyTransaction());
    }

    @Override
    public List<?> getReceiverSystemsFromCallChainSteps(Object chainId) {
        throw new NotImplementedException("Method getReceiverSystemsFromCallChainSteps is not implemented");
    }

    @Override
    public List<T> getByNameAndProjectId(String name, BigInteger projectId) {
        return ((TemplateRepository)this.repository).findByNameAndProjectId(name, IdConverter.toBigInt(projectId));
    }

    @Override
    public Collection<T> getByProjectId(BigInteger projectId) {
        return ((TemplateRepository)this.repository).findByProjectId(IdConverter.toBigInt(projectId));
    }

    public List<IdNamePair> getIdAndNameByProjectId(BigInteger projectId) {
        List<Object[]> list = ((OperationTemplateRepository)this.repository).findIdAndNameByProjectId(IdConverter.toBigInt(projectId));
        ArrayList<IdNamePair> result = new ArrayList<IdNamePair>();
        if (list != null) {
            for (Object[] item : list) {
                result.add(new IdNamePair(item[0], String.valueOf(item[1])));
            }
        }
        return result;
    }
}

