/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.executor;

import com.google.common.collect.Sets;
import com.querydsl.core.types.Predicate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.EnvConfigurationManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.ObjectCreationByTypeManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByProjectIdManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.InboundTransportConfigurationRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.OperationRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.TransportConfigurationRepository;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.QOperation;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.model.usage.UsageInfo;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransportConfigurationObjectManager
extends AbstractObjectManager<TransportConfiguration, TransportConfiguration>
implements EnvConfigurationManager<TransportConfiguration>,
ObjectCreationByTypeManager<TransportConfiguration>,
SearchByProjectIdManager<TransportConfiguration> {
    private final OperationRepository operationRepository;
    private final InboundTransportConfigurationRepository inboundTransportConfigurationRepository;
    private final TransportConfigurationRepository transportConfigurationRepository;

    @Autowired
    public TransportConfigurationObjectManager(TransportConfigurationRepository repository, OperationRepository operationRepository, InboundTransportConfigurationRepository inboundTransportConfigurationRepository) {
        super(TransportConfiguration.class, repository);
        this.operationRepository = operationRepository;
        this.inboundTransportConfigurationRepository = inboundTransportConfigurationRepository;
        this.transportConfigurationRepository = repository;
    }

    @Override
    public void protectedOnRemove(TransportConfiguration transportConfiguration) {
        this.operationRepository.onDeleteTransport(transportConfiguration);
        this.inboundTransportConfigurationRepository.onDeleteTransport(transportConfiguration);
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only TransportConfiguration objects are here")
    public Collection<UsageInfo> findUsages(Storable storable) {
        HashSet result = Sets.newHashSet();
        TransportConfigurationObjectManager.addToUsages(result, "transport", this.operationRepository.findAll((Predicate)QOperation.operation.transport().eq((TransportConfiguration)storable)));
        return result;
    }

    @Override
    public Map<String, List<BigInteger>> findImportantChildren(Storable storable) {
        if (storable instanceof TransportConfiguration) {
            List<BigInteger> stubTriggerIds = this.transportConfigurationRepository.getTransportTriggersByTransportConfigurationId(IdConverter.toBigInt(storable.getID()));
            HashMap<String, List<BigInteger>> result = new HashMap<String, List<BigInteger>>();
            result.put("TransportTriggers", stubTriggerIds);
            return result;
        }
        return super.findImportantChildren(storable);
    }

    @Override
    public TransportConfiguration create(Storable system, @Nonnull String name, @Nonnull String type, Map parameters) {
        TransportConfiguration transportConfiguration = new TransportConfiguration(system, parameters);
        transportConfiguration.setName(name);
        transportConfiguration.setTypeName(type);
        this.repository.save(transportConfiguration);
        return transportConfiguration;
    }

    @Override
    public TransportConfiguration getByEcId(String ecId, Object ... objects) {
        return TxExecutor.executeUnchecked(() -> this.transportConfigurationRepository.findTransportByEcId(ecId), TxExecutor.defaultWritableTransaction());
    }

    @Override
    public Collection<TransportConfiguration> getByEcProjectId(String ecProjectId) {
        return TxExecutor.executeUnchecked(() -> this.transportConfigurationRepository.getTransportsByEcProject(ecProjectId), TxExecutor.defaultWritableTransaction());
    }

    @Override
    public Collection<String> getEcProjectIds(BigInteger projectId) {
        return TxExecutor.executeUnchecked(() -> this.transportConfigurationRepository.getEcProjectIds(projectId), TxExecutor.defaultWritableTransaction());
    }

    @Override
    public void unbindByEcProject(String ecProjectId) {
        TxExecutor.executeUnchecked(() -> this.transportConfigurationRepository.unbindByEcProject(ecProjectId), TxExecutor.defaultWritableTransaction());
    }

    @Override
    public TransportConfiguration findByEcLabel(String ecLabel, BigInteger projectId) {
        return null;
    }

    @Override
    public Collection<TransportConfiguration> getByProjectId(BigInteger projectId) {
        return this.transportConfigurationRepository.findByProjectId(projectId);
    }

    public Collection<TransportConfiguration> findUsagesTemplateOnTransport(BigInteger templateId) {
        return this.transportConfigurationRepository.findUsagesTemplateOnTransport(templateId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only TransportConfiguration objects are here")
    public void afterDelete(Storable object) {
        if (object.getParent() instanceof System) {
            Storable storable = object.getParent();
            synchronized (storable) {
                ((System)object.getParent()).getTransports().remove((TransportConfiguration)object);
            }
        }
    }
}

