/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.executor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.javers.spring.annotation.JaversSpringDataAuditable;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.SearchRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.StorableRepository;
import org.qubership.automation.itf.core.model.IdNamePair;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@JaversSpringDataAuditable
@Repository
public interface CallChainRepository
extends SearchRepository<CallChain>,
QuerydslPredicateExecutor<Operation>,
StorableRepository<CallChain> {
    @Query(value="select new org.qubership.automation.itf.core.model.IdNamePair(chain.id, chain.name) from CallChain chain where chain.projectId = :projectId")
    public List<IdNamePair> getSimpleListByProject(@Param(value="projectId") BigInteger var1);

    @Query(value="select ch.id from mb_chain ch inner join mb_chain_labels lbl on ch.id = lbl.id where ch.project_id = :projectId and lbl.labels = :label", nativeQuery=true)
    public Collection<BigInteger> getCallchainIdsByLabel(@Param(value="label") String var1, @Param(value="projectId") BigInteger var2);

    @Query(value="select distinct ch_labels.labels from mb_chain as ch inner join mb_chain_labels as ch_labels on ch_labels.id = ch.id where project_id = :projectId union select distinct mfl.labels as labels from mb_folders as mf inner join mb_folders_labels as mfl on mfl.id =mf.id where mf.\"type\" = 'chains' and mf.project_id = :projectId", nativeQuery=true)
    public Set<String> getAllLabels(@Param(value="projectId") BigInteger var1);

    @Query(value="select count(*) from mb_bv_cases bvc where bvc.bv_tcid = :bvCaseId", nativeQuery=true)
    public int countBvCaseUsages(@Param(value="bvCaseId") String var1);

    @Query(value="select distinct parent_id from mb_steps where chain_id = :chainId", nativeQuery=true)
    public List<BigInteger> getIdsCallchains(@Param(value="chainId") BigInteger var1);

    @Query(value="select callChain from CallChain callChain where lower(callChain.name) like concat('%', lower(:name), '%') and callChain.projectId = :projectId")
    public List<CallChain> findByPieceOfNameAndProjectId(@Param(value="name") String var1, @Param(value="projectId") BigInteger var2);

    @Override
    public List<CallChain> findByNameAndProjectId(@Param(value="name") String var1, @Param(value="projectId") BigInteger var2);

    @Query(value="select distinct callchain_id from mb_bv_cases inner join mb_chain ch on callchain_id=ch.id where ch.project_id = :projectId", nativeQuery=true)
    public Collection<BigInteger> getCallChainsWithBvLinks(@Param(value="projectId") BigInteger var1);
}

