/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.executor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.javers.spring.annotation.JaversSpringDataAuditable;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.StorableRepository;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
@JaversSpringDataAuditable
public interface OperationRepository
extends StorableRepository<Operation>,
QuerydslPredicateExecutor<Operation> {
    @Modifying
    @Query(value="update Operation o set o.transport = null where o.transport = :configuration")
    public void onDeleteTransport(@Param(value="configuration") TransportConfiguration var1);

    @Query(value="select operation from Operation operation inner join System as system on system = operation.parent where lower(system.name) like concat('%', lower(:name), '%') and system.projectId = :projectId")
    public Collection<Operation> findByParentNameAndProject(@Param(value="name") String var1, @Param(value="projectId") BigInteger var2);

    @Query(value="select operation from Operation operation where lower(operation.name) like concat('%', lower(:name), '%') and operation.projectId = :projectId")
    public Collection<Operation> findByPieceOfNameAndProject(@Param(value="name") String var1, @Param(value="projectId") BigInteger var2);

    @Query(value="select operation from Operation operation where lower(operation.name) = lower(:name)and operation.projectId = :projectId")
    public List<Operation> findByNameAndProjectId(@Param(value="name") String var1, @Param(value="projectId") BigInteger var2);

    @Query(value="select id from mb_triggers where set_parent_id in (select id from mb_situation where parent_id = :operationId)", nativeQuery=true)
    public List<BigInteger> getSituationEventTriggersByOperationId(@Param(value="operationId") BigInteger var1);
}

