/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.executor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.ServerSearchRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.StorableRepository;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.server.ServerHB;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ServerRepository
extends ServerSearchRepository<ServerHB>,
StorableRepository<ServerHB> {
    @Query(value="select server from ServerHB server where server.ecId = :ecId or (server.name = :name and server.url = :url)")
    public Server findByEcId(@Param(value="ecId") String var1, @Param(value="name") String var2, @Param(value="url") String var3);

    @Query(value="select ec_project_id from mb_servers where project_id = :projectId and ec_project_id is not null group by ec_project_id", nativeQuery=true)
    public Collection<String> getEcProjectIds(@Param(value="projectId") BigInteger var1);

    @Query(value="select server from ServerHB server where server.ecProjectId = :ecProjectId")
    public Collection<Server> getByEcProject(@Param(value="ecProjectId") String var1);

    @Modifying
    @Query(value="update mb_servers set ec_project_id = null, ec_id = null where ec_project_id = :ecProjectId", nativeQuery=true)
    public void unbindByEcProject(@Param(value="ecProjectId") String var1);

    @Query(value="select id from mb_servers  where project_id = :projectId  and case when right(url,1)='/' then url else url||'/' end = :url", nativeQuery=true)
    public List<BigInteger> getServersByProjectAndUrlSlashed(@Param(value="url") String var1, @Param(value="projectId") BigInteger var2);

    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="DELETE FROM mb_configuration WHERE type = 'outbound' AND (parent_out_server_id, system_id) IN ( SELECT mc.parent_out_server_id, mc.system_id FROM mb_configuration mc LEFT JOIN mb_env_outbound eo ON mc.parent_out_server_id = eo.servers AND mc.system_id = eo.systems WHERE eo.servers IS NULL AND eo.systems IS NULL)", nativeQuery=true)
    public int deleteUnusedOutboundConfigurations();

    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="DELETE FROM mb_configuration WHERE type = 'outbound' AND parent_out_server_id IN (SELECT id FROM mb_servers WHERE project_id = :projectId) AND (parent_out_server_id, system_id) IN (SELECT mc.parent_out_server_id, mc.system_id FROM mb_configuration mc LEFT JOIN mb_env_outbound eo ON mc.parent_out_server_id = eo.servers AND mc.system_id = eo.systems WHERE eo.servers IS NULL AND eo.systems IS null and mc.parent_out_server_id in (SELECT id FROM mb_servers WHERE project_id = :projectId))", nativeQuery=true)
    public int deleteUnusedOutboundConfigurationsByProjectId(@Param(value="projectId") BigInteger var1);

    @Query(value="select id from mb_configuration where parent_conf_id in (select id from mb_configuration where parent_in_server_id = :serverId)", nativeQuery=true)
    public List<BigInteger> getTransportTriggersByServerId(@Param(value="serverId") BigInteger var1);
}

