/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.executor;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.SearchRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.StorableRepository;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.util.provider.TemplateProvider;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.query.Param;

@NoRepositoryBean
public interface TemplateRepository<K extends TemplateProvider, T extends Template<K>>
extends StorableRepository<T>,
QuerydslPredicateExecutor<T>,
SearchRepository<T> {
    @Query(value="select distinct templ_labels.labels from mb_templates as templates inner join mb_templates_labels as templ_labels on templ_labels.id = templates.id where templates.project_id = :projectId", nativeQuery=true)
    public Set<String> getAllLabels(@Param(value="projectId") BigInteger var1);

    @Query(value="select sys.name as system_name, ser.name as server_name, env.id as env_id, env.name as env_name from mb_configuration conf inner join mb_systems sys on sys.id = conf.system_id inner join mb_servers ser on ser.id = conf.parent_out_server_id inner join mb_env_outbound env_outbound  on (env_outbound.systems = conf.system_id and env_outbound.servers = conf.parent_out_server_id) inner join mb_env env on env.id = env_outbound.environment_id where conf.type_name = 'org.qubership.automation.itf.transport.diameter.outbound.DiameterOutbound' and conf.type = 'outbound' and sys.project_id = :projectId and ((cast(conf.params as jsonb) @> (cast((concat('{\"DPR\":\"', :templateId, '\"}')) as jsonb))) or (cast(conf.params as jsonb) @> (cast((concat('{\"dwa\":\"', :templateId, '\"}')) as jsonb))) or (cast(conf.params as jsonb) @> (cast((concat('{\"CER\":\"', :templateId, '\"}')) as jsonb))) or (cast(conf.params as jsonb) @> (cast((concat('{\"DPA\":\"', :templateId, '\"}')) as jsonb))))", nativeQuery=true)
    public List<Map<String, Object>> findUsagesOnOutboundDiameterConfiguration(@Param(value="templateId") BigInteger var1, @Param(value="projectId") BigInteger var2);
}

