/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.executor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.javers.spring.annotation.JaversSpringDataAuditable;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.StorableRepository;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
@JaversSpringDataAuditable
public interface TransportConfigurationRepository
extends StorableRepository<TransportConfiguration> {
    @Query(value="select transport from TransportConfiguration transport where transport.ecId = :ecId")
    public TransportConfiguration findTransportByEcId(@Param(value="ecId") String var1);

    @Query(value="select conf.ec_project_id from mb_configuration as conf inner join mb_systems as sys on sys.id = conf.parent_system_id where conf.ec_project_id is not null and type = 'transport' AND sys.project_id = :projectId group by conf.ec_project_id", nativeQuery=true)
    public Collection<String> getEcProjectIds(@Param(value="projectId") BigInteger var1);

    @Modifying
    @Query(value="update mb_configuration set ec_project_id = null, ec_id = null where ec_project_id = :ecProjectId and type = 'transport'", nativeQuery=true)
    public void unbindByEcProject(@Param(value="ecProjectId") String var1);

    @Query(value="select transport from TransportConfiguration transport where transport.ecProjectId = :ecProjectId")
    public Collection<TransportConfiguration> getTransportsByEcProject(@Param(value="ecProjectId") String var1);

    @Query(value="select configuration from TransportConfiguration configuration inner join System as system on system = configuration.parent where system.projectId = :projectId")
    public Collection<TransportConfiguration> findByProjectId(@Param(value="projectId") BigInteger var1);

    @Query(value="select id from mb_configuration where parent_conf_id in (select id from mb_configuration where transport_id = :transportId)", nativeQuery=true)
    public List<BigInteger> getTransportTriggersByTransportConfigurationId(@Param(value="transportId") BigInteger var1);

    @Query(value="select conf.* from mb_configuration conf where type_name = 'org.qubership.automation.itf.transport.diameter.outbound.DiameterOutbound' and type = 'transport' and ((cast(conf.params as jsonb) @> (cast((concat('{\"DPR\":\"', :templateId, '\"}')) as jsonb))) or (cast(conf.params as jsonb) @> (cast((concat('{\"dwa\":\"', :templateId, '\"}')) as jsonb))) or (cast(conf.params as jsonb) @> (cast((concat('{\"CER\":\"', :templateId, '\"}')) as jsonb))) or (cast(conf.params as jsonb) @> (cast((concat('{\"DPA\":\"', :templateId, '\"}')) as jsonb))))", nativeQuery=true)
    public Collection<TransportConfiguration> findUsagesTemplateOnTransport(@Param(value="templateId") BigInteger var1);
}

